/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.filter;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataResolver;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.ClientFilter;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.annotation.FilterMatcher;
import io.micronaut.http.client.filter.ClientFilterResolutionContext;
import io.micronaut.http.filter.BaseFilterProcessor;
import io.micronaut.http.filter.FilterOrder;
import io.micronaut.http.filter.FilterPatternStyle;
import io.micronaut.http.filter.GenericHttpFilter;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.http.filter.HttpClientFilterResolver;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.http.filter.HttpFilterResolver;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@Internal
@Singleton
@BootstrapContextCompatible
public class DefaultHttpClientFilterResolver
extends BaseFilterProcessor<ClientFilter>
implements HttpClientFilterResolver<ClientFilterResolutionContext> {
    private final List<ClientFilterEntry> clientFilters;

    public DefaultHttpClientFilterResolver(BeanContext beanContext, AnnotationMetadataResolver annotationMetadataResolver, List<HttpClientFilter> legacyClientFilters) {
        super(beanContext, ClientFilter.class);
        this.clientFilters = legacyClientFilters.stream().map(legacyClientFilter -> this.createClientFilterEntry(annotationMetadataResolver, (HttpClientFilter)legacyClientFilter)).collect(Collectors.toList());
    }

    public List<HttpFilterResolver.FilterEntry> resolveFilterEntries(ClientFilterResolutionContext context) {
        return this.clientFilters.stream().filter(entry -> this.matchesClientFilterEntry(context, (ClientFilterEntry)entry)).collect(Collectors.toList());
    }

    public List<GenericHttpFilter> resolveFilters(HttpRequest<?> request, List<HttpFilterResolver.FilterEntry> filterEntries) {
        String requestPath = StringUtils.prependUri((String)"/", (String)request.getUri().getPath());
        HttpMethod method = request.getMethod();
        ArrayList<GenericHttpFilter> filterList = new ArrayList<GenericHttpFilter>(filterEntries.size());
        for (HttpFilterResolver.FilterEntry filterEntry : filterEntries) {
            GenericHttpFilter filter = filterEntry.getFilter();
            if (!GenericHttpFilter.isEnabled((GenericHttpFilter)filter) || !this.matchesFilterEntry(method, requestPath, filterEntry)) continue;
            filterList.add(filter);
        }
        return filterList;
    }

    private boolean containsIdentifier(Collection<String> clientIdentifiers, Collection<String> clients) {
        return clients.stream().anyMatch(clientIdentifiers::contains);
    }

    private boolean anyPatternMatches(String requestPath, String[] patterns, FilterPatternStyle patternStyle) {
        return Arrays.stream(patterns).anyMatch(pattern -> patternStyle.getPathMatcher().matches(pattern, requestPath));
    }

    private boolean anyMethodMatches(HttpMethod requestMethod, Collection<HttpMethod> methods) {
        return methods.contains(requestMethod);
    }

    protected void addFilter(Supplier<GenericHttpFilter> factory, AnnotationMetadata methodAnnotations, BaseFilterProcessor.FilterMetadata metadata) {
        this.clientFilters.add(new ClientFilterEntry(factory.get(), methodAnnotations, metadata.methods() != null ? new HashSet<HttpMethod>(metadata.methods()) : Collections.emptySet(), metadata.patternStyle(), metadata.patterns(), metadata.serviceId(), metadata.excludeServiceId()));
    }

    private boolean matchesFilterEntry(@NonNull HttpMethod method, @NonNull String requestPath, @NonNull HttpFilterResolver.FilterEntry filterEntry) {
        boolean matches = true;
        if (filterEntry.hasMethods()) {
            matches = this.anyMethodMatches(method, filterEntry.getFilterMethods());
        }
        if (filterEntry.hasPatterns()) {
            matches = matches && this.anyPatternMatches(requestPath, filterEntry.getPatterns(), filterEntry.getPatternStyle());
        }
        return matches;
    }

    private boolean matchesClientFilterEntry(@NonNull ClientFilterResolutionContext context, @NonNull ClientFilterEntry entry) {
        AnnotationMetadata annotationMetadata = entry.getAnnotationMetadata();
        boolean matches = !annotationMetadata.hasStereotype(FilterMatcher.class);
        String filterAnnotation = annotationMetadata.getAnnotationNameByStereotype(FilterMatcher.class).orElse(null);
        if (filterAnnotation != null && !matches) {
            matches = context.getAnnotationMetadata().hasStereotype(filterAnnotation);
        }
        if (matches && entry.serviceIds != null) {
            matches = this.containsIdentifier(context.getClientIds(), entry.serviceIds);
        }
        if (matches && entry.excludeServiceIds != null) {
            matches = !this.containsIdentifier(context.getClientIds(), entry.excludeServiceIds);
        }
        return matches;
    }

    @NonNull
    private ClientFilterEntry createClientFilterEntry(@NonNull AnnotationMetadataResolver annotationMetadataResolver, @NonNull HttpClientFilter httpClientFilter) {
        AnnotationMetadata annotationMetadata = annotationMetadataResolver.resolveMetadata((Object)httpClientFilter);
        FilterPatternStyle patternStyle = annotationMetadata.enumValue(Filter.class, "patternStyle", FilterPatternStyle.class).orElse(FilterPatternStyle.ANT);
        return new ClientFilterEntry(GenericHttpFilter.createLegacyFilter((HttpFilter)httpClientFilter, (FilterOrder)new FilterOrder.Dynamic(OrderUtil.getOrder((AnnotationMetadata)annotationMetadata))), annotationMetadata, DefaultHttpClientFilterResolver.methodsForFilter(annotationMetadata), patternStyle, List.of(annotationMetadata.stringValues(Filter.class)), DefaultHttpClientFilterResolver.serviceIdsForFilter(annotationMetadata), DefaultHttpClientFilterResolver.excludeServiceIdsForFilter(annotationMetadata));
    }

    @Nullable
    private static List<String> excludeServiceIdsForFilter(@NonNull AnnotationMetadata annotationMetadata) {
        return DefaultHttpClientFilterResolver.idsForFilter(annotationMetadata, "excludeServiceId");
    }

    @Nullable
    private static List<String> serviceIdsForFilter(@NonNull AnnotationMetadata annotationMetadata) {
        return DefaultHttpClientFilterResolver.idsForFilter(annotationMetadata, "serviceId");
    }

    @Nullable
    private static List<String> idsForFilter(@NonNull AnnotationMetadata annotationMetadata, @NonNull String member) {
        Object[] ids = annotationMetadata.stringValues(Filter.class, member);
        return ArrayUtils.isNotEmpty((Object[])ids) ? List.of(ids) : null;
    }

    @NonNull
    private static Set<HttpMethod> methodsForFilter(@NonNull AnnotationMetadata annotationMetadata) {
        HttpMethod[] methods = (HttpMethod[])annotationMetadata.enumValues(Filter.class, "methods", HttpMethod.class);
        HashSet<HttpMethod> httpMethods = new HashSet<HttpMethod>(Arrays.asList(methods));
        if (annotationMetadata.hasStereotype(FilterMatcher.class)) {
            httpMethods.addAll(Arrays.asList((HttpMethod[])annotationMetadata.enumValues(FilterMatcher.class, "methods", HttpMethod.class)));
        }
        return httpMethods;
    }

    private record ClientFilterEntry(GenericHttpFilter filter, AnnotationMetadata annotationMetadata, Set<HttpMethod> httpMethods, FilterPatternStyle patternStyle, List<String> patterns, @Nullable List<String> serviceIds, @Nullable List<String> excludeServiceIds) implements HttpFilterResolver.FilterEntry
    {
        @NonNull
        public AnnotationMetadata getAnnotationMetadata() {
            return this.annotationMetadata;
        }

        public GenericHttpFilter getFilter() {
            return this.filter;
        }

        public Set<HttpMethod> getFilterMethods() {
            return this.httpMethods;
        }

        public String[] getPatterns() {
            return (String[])this.patterns.toArray(String[]::new);
        }

        public FilterPatternStyle getPatternStyle() {
            return this.patternStyle;
        }

        public boolean hasMethods() {
            return CollectionUtils.isNotEmpty(this.httpMethods);
        }

        public boolean hasPatterns() {
            return CollectionUtils.isNotEmpty(this.patterns);
        }
    }
}

