/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.client;

import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.discovery.DiscoveryClient;
import io.micronaut.function.client.FunctionDefinition;
import io.micronaut.function.client.FunctionDefinitionProvider;
import io.micronaut.function.client.FunctionDiscoveryClient;
import io.micronaut.function.client.exceptions.FunctionNotFoundException;
import io.micronaut.health.HealthStatus;
import io.reactivex.Flowable;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Singleton
public class DefaultFunctionDiscoveryClient
implements FunctionDiscoveryClient {
    private final DiscoveryClient discoveryClient;
    private final Map<String, FunctionDefinition> functionDefinitionMap;

    public DefaultFunctionDiscoveryClient(DiscoveryClient discoveryClient, FunctionDefinitionProvider[] providers, FunctionDefinition ... definitions) {
        this.discoveryClient = discoveryClient;
        this.functionDefinitionMap = new HashMap<String, FunctionDefinition>(definitions.length);
        for (FunctionDefinition definition : definitions) {
            this.functionDefinitionMap.put(definition.getName(), definition);
        }
        for (FunctionDefinitionProvider provider : providers) {
            Collection<FunctionDefinition> functionDefinitions = provider.getFunctionDefinitions();
            for (FunctionDefinition definition : functionDefinitions) {
                this.functionDefinitionMap.put(definition.getName(), definition);
            }
        }
    }

    @Override
    public Publisher<FunctionDefinition> getFunction(final String functionName) {
        if (this.functionDefinitionMap.containsKey(functionName)) {
            return Publishers.just((Object)this.functionDefinitionMap.get(functionName));
        }
        Flowable serviceInstanceLocator = Flowable.fromPublisher((Publisher)this.discoveryClient.getServiceIds()).flatMap(Flowable::fromIterable).flatMap(arg_0 -> ((DiscoveryClient)this.discoveryClient).getInstances(arg_0)).flatMap(Flowable::fromIterable).filter(instance -> {
            boolean isAvailable = instance.getHealthStatus().equals((Object)HealthStatus.UP);
            return isAvailable && instance.getMetadata().names().stream().anyMatch(k -> k.equals("function:" + functionName));
        }).switchIfEmpty((Publisher)Flowable.error((Throwable)new FunctionNotFoundException(functionName)));
        return serviceInstanceLocator.map(instance -> {
            Optional uri = instance.getMetadata().get((CharSequence)("function:" + functionName), String.class);
            if (uri.isPresent()) {
                final URI resolvedURI = instance.getURI().resolve((String)uri.get());
                return new FunctionDefinition(){

                    @Override
                    public String getName() {
                        return functionName;
                    }

                    @Override
                    public Optional<URI> getURI() {
                        return Optional.of(resolvedURI);
                    }
                };
            }
            throw new FunctionNotFoundException(functionName);
        });
    }
}

