/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.io.watch;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.CachedEnvironment;
import io.micronaut.scheduling.io.watch.FileWatchCondition;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.WatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requirements(value={@Requires(property="micronaut.io.watch.enabled", value="true", defaultValue="true"), @Requires(condition=FileWatchCondition.class), @Requires(missingClasses={"io.methvin.watchservice.MacOSXListeningWatchService"})})
@Factory
public class WatchServiceFactory {
    protected static final Logger LOG = LoggerFactory.getLogger(WatchServiceFactory.class);

    @Bean(preDestroy="close")
    @Prototype
    @Requirements(value={@Requires(missingClasses={"io.methvin.watchservice.MacOSXListeningWatchService"}), @Requires(property="micronaut.io.watch.enabled", value="true", defaultValue="true"), @Requires(property="micronaut.io.watch.paths")})
    @Primary
    public WatchService watchService() throws IOException {
        boolean isMacOS;
        String name = CachedEnvironment.getProperty((String)"os.name").toLowerCase();
        boolean bl = isMacOS = "Mac OS X".equalsIgnoreCase(name) || "Darwin".equalsIgnoreCase(name);
        if (isMacOS) {
            LOG.warn("Using default File WatchService on OS X is slow. Consider adding 'io.micronaut:micronaut-runtime-osx' dependencies to use native file watch");
        }
        return FileSystems.getDefault().newWatchService();
    }
}

