/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.context;

import io.micronaut.context.AbstractMessageSource;
import io.micronaut.context.MessageSource;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@Primary
public final class CompositeMessageSource
extends AbstractMessageSource {
    private final List<MessageSource> messageSources;

    @Deprecated
    public CompositeMessageSource(@Nullable Collection<MessageSource> messageSources) {
        this((List<MessageSource>)(messageSources == null ? Collections.emptyList() : new ArrayList<MessageSource>(messageSources)));
    }

    @Inject
    public CompositeMessageSource(@Nullable List<MessageSource> messageSources) {
        this.messageSources = messageSources != null ? messageSources : Collections.emptyList();
    }

    @NonNull
    public Optional<String> getRawMessage(@NonNull String code, @NonNull MessageSource.MessageContext context) {
        ArgumentUtils.requireNonNull((String)"code", (Object)code);
        ArgumentUtils.requireNonNull((String)"context", (Object)context);
        for (MessageSource messageSource : this.messageSources) {
            Optional message = messageSource.getRawMessage(code, context);
            if (!message.isPresent()) continue;
            return message;
        }
        return Optional.empty();
    }
}

