/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.buffer.netty;

import io.micronaut.buffer.netty.NettyByteBuffer;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
final class NettyReadBuffer
extends ReadBuffer {
    ByteBuf buf;

    NettyReadBuffer(ByteBuf buf) {
        this.buf = buf;
    }

    private ByteBuf getBuf() {
        ByteBuf buf = this.buf;
        if (buf == null) {
            throw new IllegalStateException("Already released");
        }
        return buf;
    }

    public int readable() {
        return this.getBuf().readableBytes();
    }

    public @NonNull ReadBuffer duplicate() {
        return new NettyReadBuffer(this.getBuf().retainedDuplicate());
    }

    public @NonNull ReadBuffer split(int splitPosition) {
        return new NettyReadBuffer(this.getBuf().readRetainedSlice(splitPosition));
    }

    public ReadBuffer move() {
        ByteBuf b = this.getBuf();
        this.buf = null;
        return new NettyReadBuffer(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toArray(byte @NonNull [] destination, int offset) throws IndexOutOfBoundsException {
        ByteBuf b = this.getBuf();
        try {
            this.buf = null;
            if (offset > destination.length) {
                throw new IndexOutOfBoundsException("Offset exceeds length");
            }
            b.readBytes(destination, offset, b.readableBytes());
        }
        finally {
            b.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull String toString(Charset charset) {
        ByteBuf b = this.getBuf();
        try {
            this.buf = null;
            String string = b.toString(charset);
            return string;
        }
        finally {
            b.release();
        }
    }

    public @NonNull io.micronaut.core.io.buffer.ByteBuffer<?> toByteBuffer() {
        ByteBuf b = this.getBuf();
        this.buf = null;
        return new NettyByteBuffer(b);
    }

    public InputStream toInputStream() {
        ByteBuf b = this.getBuf();
        this.buf = null;
        return new ByteBufInputStream(b, true);
    }

    public <R> @Nullable R useFastHeapBuffer(@NonNull Function<ByteBuffer, @NonNull R> function) {
        ByteBuf b = this.getBuf();
        if (b.hasArray()) {
            this.buf = null;
            return function.apply(ByteBuffer.wrap(b.array(), b.arrayOffset() + b.readerIndex(), b.readableBytes()));
        }
        return (R)super.useFastHeapBuffer(function);
    }

    public void transferTo(@NonNull OutputStream stream) throws IOException {
        ByteBuf b = this.getBuf();
        this.buf = null;
        try {
            b.readBytes(stream, b.readableBytes());
        }
        finally {
            b.release();
        }
    }

    ByteBuf toByteBuf() {
        ByteBuf b = this.getBuf();
        this.buf = null;
        return b;
    }

    public void close() {
        ByteBuf buf = this.buf;
        if (buf != null) {
            buf.release();
            this.buf = null;
        }
    }

    protected boolean isConsumed() {
        return this.buf == null;
    }

    protected byte[] peekArray(int n) {
        ByteBuf b = this.getBuf();
        byte[] arr = new byte[n];
        b.getBytes(b.readerIndex(), arr);
        return arr;
    }
}

