/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.buffer.netty;

import io.micronaut.buffer.netty.NettyReadBuffer;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.micronaut.core.io.buffer.ReadBufferFactory;
import io.micronaut.core.util.functional.ThrowingConsumer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class NettyReadBufferFactory
extends ReadBufferFactory {
    private final ByteBufAllocator allocator;

    private NettyReadBufferFactory(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    @NonNull
    public static NettyReadBufferFactory of(@NonNull ByteBufAllocator allocator) {
        return new NettyReadBufferFactory(allocator);
    }

    public ReadBuffer createEmpty() {
        return new NettyReadBuffer(Unpooled.EMPTY_BUFFER);
    }

    @NonNull
    public ReadBuffer copyOf(@NonNull CharSequence cs, @NonNull Charset charset) {
        ByteBuf byteBuf = charset == StandardCharsets.UTF_8 ? ByteBufUtil.writeUtf8((ByteBufAllocator)this.allocator, (CharSequence)cs) : ByteBufUtil.encodeString((ByteBufAllocator)this.allocator, (CharBuffer)CharBuffer.wrap(cs), (Charset)charset);
        return this.adapt(byteBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ReadBuffer copyOf(@NonNull InputStream stream) throws IOException {
        ByteBuf buffer = this.allocator.buffer();
        boolean free = true;
        try {
            while (buffer.writeBytes(stream, 4096) != -1) {
            }
            free = false;
            ReadBuffer readBuffer = this.adapt(buffer);
            return readBuffer;
        }
        finally {
            if (free) {
                buffer.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ReadBuffer copyOf(@NonNull ByteBuffer nioBuffer) {
        ByteBuf bb = this.allocator.buffer(nioBuffer.remaining());
        boolean done = false;
        try {
            bb.writeBytes(nioBuffer);
            done = true;
            ReadBuffer readBuffer = this.adapt(bb);
            return readBuffer;
        }
        finally {
            if (!done) {
                bb.release();
            }
        }
    }

    @NonNull
    public ReadBuffer adapt(@NonNull ByteBuffer nioBuffer) {
        return this.adapt(Unpooled.wrappedBuffer((ByteBuffer)nioBuffer));
    }

    @NonNull
    public ReadBuffer adapt(@NonNull io.micronaut.core.io.buffer.ByteBuffer<?> buffer) {
        Object object = buffer.asNativeBuffer();
        if (object instanceof ByteBuf) {
            ByteBuf bb = (ByteBuf)object;
            return this.adapt(bb);
        }
        return super.adapt(buffer);
    }

    public ReadBuffer adapt(byte @NonNull [] array) {
        return this.adapt(Unpooled.wrappedBuffer((byte[])array));
    }

    @NonNull
    public ReadBuffer adapt(@NonNull ByteBuf buffer) {
        return new NettyReadBuffer(buffer);
    }

    @NonNull
    public static ByteBuf toByteBuf(@NonNull ReadBuffer readBuffer) {
        if (readBuffer instanceof NettyReadBuffer) {
            NettyReadBuffer nrb = (NettyReadBuffer)readBuffer;
            return nrb.toByteBuf();
        }
        return Unpooled.wrappedBuffer((byte[])readBuffer.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public <T extends Throwable> ReadBuffer buffer(@NonNull ThrowingConsumer<? super OutputStream, T> writer) throws T {
        ByteBuf buf = this.allocator.buffer();
        boolean release = true;
        try {
            ByteBufOutputStream s = new ByteBufOutputStream(buf);
            writer.accept((Object)s);
            try {
                s.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to close buffer stream", e);
            }
            release = false;
            ReadBuffer readBuffer = this.adapt(buf);
            return readBuffer;
        }
        finally {
            if (release) {
                buf.release();
            }
        }
    }

    @NonNull
    public ReadBufferFactory.BufferingOutputStream outputStreamBuffer() {
        return new ReadBufferFactory.BufferingOutputStream(){
            ByteBufOutputStream out;
            {
                this.out = new ByteBufOutputStream(NettyReadBufferFactory.this.allocator.buffer());
            }

            public OutputStream stream() throws IllegalStateException {
                ByteBufOutputStream out = this.out;
                if (out == null) {
                    throw new IllegalStateException("Already converted to buffer");
                }
                return out;
            }

            public ReadBuffer finishBuffer() throws IOException {
                ByteBufOutputStream out = this.out;
                if (out == null) {
                    throw new IllegalStateException("Already converted to buffer");
                }
                this.out = null;
                boolean release = true;
                try {
                    out.close();
                    release = false;
                }
                finally {
                    if (release) {
                        out.buffer().release();
                    }
                }
                return NettyReadBufferFactory.this.adapt(out.buffer());
            }

            public void close() throws IOException {
                ByteBufOutputStream out = this.out;
                if (out != null) {
                    try {
                        out.close();
                    }
                    finally {
                        out.buffer().release();
                    }
                }
            }
        };
    }

    @NonNull
    public ReadBuffer compose(@NonNull @NonNull Iterable<@NonNull ReadBuffer> buffers) {
        CompositeByteBuf composite = this.allocator.compositeBuffer();
        try {
            for (ReadBuffer buffer : buffers) {
                composite.addComponent(true, NettyReadBufferFactory.toByteBuf(buffer));
            }
            return this.adapt((ByteBuf)composite);
        }
        catch (Throwable e) {
            composite.release();
            for (ReadBuffer buffer : buffers) {
                try {
                    buffer.close();
                }
                catch (Throwable f) {
                    e.addSuppressed(f);
                }
            }
            throw e;
        }
    }
}

