/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.testresources;

import io.micronaut.gradle.MicronautBasePlugin;
import io.micronaut.gradle.MicronautExtension;
import io.micronaut.gradle.PluginsHelper;
import io.micronaut.gradle.testresources.StartTestResourcesService;
import io.micronaut.gradle.testresources.StopTestResourcesService;
import io.micronaut.gradle.testresources.TestResourcesConfiguration;
import io.micronaut.gradle.testresources.internal.TestResourcesAOT;
import io.micronaut.gradle.testresources.internal.TestResourcesGraalVM;
import io.micronaut.testresources.buildtools.MavenDependency;
import io.micronaut.testresources.buildtools.ServerUtils;
import io.micronaut.testresources.buildtools.TestResourcesClasspath;
import io.micronaut.testresources.buildtools.VersionInfo;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.session.BuildSessionLifecycleListener;

public class MicronautTestResourcesPlugin
implements Plugin<Project> {
    public static final String START_TEST_RESOURCES_SERVICE = "startTestResourcesService";
    public static final String START_TEST_RESOURCES_SERVICE_INTERNAL = "internalStartTestResourcesService";
    public static final String STOP_TEST_RESOURCES_SERVICE = "stopTestResourcesService";
    public static final String GROUP = "Micronaut Test Resources";
    public static final String TESTRESOURCES_CONFIGURATION = "testResourcesService";
    public static final String TESTRESOURCES_ELEMENTS_CONFIGURATION = "testresourcesSettingsElements";
    public static final String MICRONAUT_TEST_RESOURCES_USAGE = "micronaut.test.resources";
    private static final int DEFAULT_CLIENT_TIMEOUT_SECONDS = 60;

    public static void addTestResourcesClientDependencies(Project project, TestResourcesConfiguration config, DependencyHandler dependencies, TaskProvider<StartTestResourcesService> writeTestProperties, Configuration conf) {
        conf.getDependencies().addAllLater(config.getVersion().map(v -> {
            if (Boolean.TRUE.equals(config.getEnabled().get())) {
                return Collections.singleton(dependencies.create((Object)("io.micronaut.testresources:micronaut-test-resources-client:" + v)));
            }
            return Collections.emptyList();
        }));
        conf.getDependencies().addAllLater(config.getEnabled().map(enabled -> {
            if (Boolean.TRUE.equals(enabled)) {
                return Collections.singleton(dependencies.create((Object)project.files(new Object[]{writeTestProperties})));
            }
            return Collections.emptyList();
        }));
        conf.getDependencyConstraints().addAllLater(PluginsHelper.findMicronautVersionAsProvider((Project)project).map(v -> Stream.of("micronaut-http-client", "micronaut-bom", "micronaut-inject").map(artifact -> dependencies.getConstraints().create((Object)("io.micronaut:" + artifact), dc -> {
            dc.because("Aligning version of Micronaut the current Micronaut version");
            dc.version(version -> version.strictly(v));
        })).collect(Collectors.toList())));
    }

    public void apply(Project project) {
        PluginManager pluginManager = project.getPluginManager();
        pluginManager.apply(JavaPlugin.class);
        pluginManager.apply(MicronautBasePlugin.class);
        this.configurePlugin(project);
    }

    private void configurePlugin(Project project) {
        Configuration server = MicronautTestResourcesPlugin.createTestResourcesServerConfiguration(project);
        Configuration outgoing = MicronautTestResourcesPlugin.createTestResourcesOutgoingConfiguration(project);
        ProviderFactory providers = project.getProviders();
        Provider explicitPort = providers.systemProperty("micronaut.test-resources.server.port").map(Integer::parseInt);
        TestResourcesConfiguration config = this.createTestResourcesConfiguration(project, (Provider<Integer>)explicitPort);
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        SourceSet testResourcesSourceSet = this.createTestResourcesSourceSet(javaPluginExtension);
        DependencyHandler dependencies = project.getDependencies();
        Configuration testResourcesApi = project.getConfigurations().getByName(testResourcesSourceSet.getImplementationConfigurationName());
        testResourcesApi.getDependencies().addLater(config.getVersion().map(v -> dependencies.create((Object)("io.micronaut.testresources:micronaut-test-resources-core:" + v))));
        server.getDependencies().addAllLater(this.buildTestResourcesDependencyList(project, dependencies, config, testResourcesSourceSet));
        String accessToken = UUID.randomUUID().toString();
        Provider accessTokenProvider = providers.provider(() -> accessToken);
        DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
        Provider settingsDirectory = config.getSharedServer().flatMap(shared -> {
            DirectoryProperty directoryProperty = project.getObjects().directoryProperty();
            if (Boolean.TRUE.equals(shared)) {
                String namespace = (String)config.getSharedServerNamespace().getOrNull();
                directoryProperty.set(ServerUtils.getDefaultSharedSettingsPath((String)namespace).toFile());
            }
            return directoryProperty;
        }).orElse(buildDirectory.dir("test-resources-settings"));
        Provider portFile = buildDirectory.file("test-resources-port.txt");
        Path stopAtEndFile = this.createStopFile(project);
        TaskContainer tasks = project.getTasks();
        Provider isStandalone = config.getSharedServer().zip(providers.provider(() -> {
            boolean singleTask = project.getGradle().getStartParameter().getTaskNames().size() == 1;
            boolean onlyStartTask = project.getGradle().getTaskGraph().getAllTasks().stream().anyMatch(task -> task.getProject().equals(project) && task.getName().equals(START_TEST_RESOURCES_SERVICE));
            return singleTask && onlyStartTask;
        }), (shared, singleTask) -> shared != false || singleTask != false);
        Provider cdsDir = buildDirectory.dir("test-resources/cds");
        TaskProvider<StartTestResourcesService> internalStart = this.createStartServiceTask(server, config, (Provider<Directory>)settingsDirectory, (Provider<String>)accessTokenProvider, tasks, (Provider<RegularFile>)portFile, stopAtEndFile, (Provider<Boolean>)isStandalone, (Provider<Directory>)cdsDir);
        tasks.register(START_TEST_RESOURCES_SERVICE, task -> {
            task.dependsOn(new Object[]{internalStart});
            task.setOnlyIf(t -> (Boolean)config.getEnabled().get());
            task.setGroup(GROUP);
            task.setDescription("Starts the test resources server in standalone mode");
        });
        this.createStopServiceTask((Provider<Directory>)settingsDirectory, tasks);
        project.afterEvaluate(p -> p.getConfigurations().all(conf -> this.configureDependencies(project, config, dependencies, internalStart, (Configuration)conf)));
        outgoing.getOutgoing().artifact(internalStart);
        outgoing.getDependencies().addLater(config.getVersion().map(v -> dependencies.create((Object)("io.micronaut.testresources:micronaut-test-resources-client:" + v))));
        Configuration testResourcesClasspathConfig = this.createTestResourcesClasspathConfig(project, config, internalStart);
        PluginManager pluginManager = project.getPluginManager();
        pluginManager.withPlugin("org.graalvm.buildtools.native", unused -> TestResourcesGraalVM.configure(project, tasks, testResourcesClasspathConfig));
        pluginManager.withPlugin("io.micronaut.aot", unused -> TestResourcesAOT.configure(project, config, dependencies, tasks, internalStart, testResourcesClasspathConfig));
        this.configureServiceReset((ProjectInternal)project, (Provider<Directory>)settingsDirectory, stopAtEndFile);
    }

    private Configuration createTestResourcesClasspathConfig(Project project, TestResourcesConfiguration config, TaskProvider<StartTestResourcesService> startTestResourcesServiceTaskProvider) {
        return (Configuration)project.getConfigurations().create("testResourcesClasspath", conf -> {
            conf.setCanBeResolved(true);
            conf.setCanBeConsumed(false);
            conf.attributes(attrs -> {
                ObjectFactory objects = project.getObjects();
                attrs.attribute(Usage.USAGE_ATTRIBUTE, (Object)objects.named(Usage.class, "java-runtime"));
                attrs.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)objects.named(Bundling.class, "external"));
                attrs.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)objects.named(LibraryElements.class, "classes+resources"));
            });
            MicronautTestResourcesPlugin.addTestResourcesClientDependencies(project, config, project.getDependencies(), startTestResourcesServiceTaskProvider, conf);
        });
    }

    private Path createStopFile(Project project) {
        Path stopAtEndFile;
        try {
            File asFile = ((RegularFile)project.getLayout().getBuildDirectory().file("test-resources/" + UUID.randomUUID()).get()).getAsFile();
            File parentDir = asFile.getParentFile();
            if (!parentDir.isDirectory() && !parentDir.mkdirs()) {
                throw new IOException("Could not create directory for test resources stop file at " + parentDir.getAbsolutePath());
            }
            asFile.deleteOnExit();
            stopAtEndFile = asFile.toPath();
            Files.deleteIfExists(stopAtEndFile);
        }
        catch (IOException e) {
            throw new GradleException("Unable to create temp file", (Throwable)e);
        }
        return stopAtEndFile;
    }

    private SourceSet createTestResourcesSourceSet(JavaPluginExtension javaPluginExtension) {
        return (SourceSet)javaPluginExtension.getSourceSets().create("testResources");
    }

    private void createStopServiceTask(Provider<Directory> settingsDirectory, TaskContainer tasks) {
        tasks.register(STOP_TEST_RESOURCES_SERVICE, StopTestResourcesService.class, task -> task.getSettingsDirectory().convention(settingsDirectory));
    }

    private void configureDependencies(Project project, TestResourcesConfiguration config, DependencyHandler dependencies, TaskProvider<StartTestResourcesService> writeTestProperties, Configuration conf) {
        String name = conf.getName();
        if ("developmentOnly".equals(name) || "testRuntimeOnly".equals(name)) {
            MicronautTestResourcesPlugin.addTestResourcesClientDependencies(project, config, dependencies, writeTestProperties, conf);
        }
    }

    private TaskProvider<StartTestResourcesService> createStartServiceTask(Configuration server, TestResourcesConfiguration config, Provider<Directory> settingsDirectory, Provider<String> accessToken, TaskContainer tasks, Provider<RegularFile> portFile, Path stopFile, Provider<Boolean> isStandalone, Provider<Directory> cdsDir) {
        return tasks.register(START_TEST_RESOURCES_SERVICE_INTERNAL, StartTestResourcesService.class, task -> {
            task.setOnlyIf(t -> (Boolean)config.getEnabled().get());
            task.getPortFile().convention(portFile);
            task.getSettingsDirectory().convention(settingsDirectory);
            task.getAccessToken().convention(accessToken);
            task.getExplicitPort().convention(config.getExplicitPort());
            task.getClientTimeout().convention(config.getClientTimeout());
            task.getClasspath().from(new Object[]{server});
            task.getForeground().convention((Object)false);
            task.getStopFile().set(stopFile.toFile());
            task.getStandalone().set(isStandalone);
            task.getClassDataSharingDir().convention(cdsDir);
            task.getUseClassDataSharing().convention((Object)JavaVersion.current().isCompatibleWith(JavaVersion.VERSION_17));
        });
    }

    private TestResourcesConfiguration createTestResourcesConfiguration(Project project, Provider<Integer> explicitPort) {
        MicronautExtension micronautExtension = PluginsHelper.findMicronautExtension((Project)project);
        TestResourcesConfiguration testResources = (TestResourcesConfiguration)micronautExtension.getExtensions().create("testResources", TestResourcesConfiguration.class, new Object[0]);
        ProviderFactory providers = project.getProviders();
        testResources.getEnabled().convention(micronautExtension.getVersion().orElse(providers.gradleProperty("micronautVersion")).map(MicronautTestResourcesPlugin::isAtLeastMicronaut3dot5));
        testResources.getVersion().convention((Object)VersionInfo.getVersion());
        testResources.getExplicitPort().convention(explicitPort);
        testResources.getInferClasspath().convention((Object)true);
        testResources.getClientTimeout().convention((Object)60);
        testResources.getSharedServer().convention(providers.gradleProperty("shared.test.resources").orElse(providers.systemProperty("shared.test.resources")).orElse(providers.environmentVariable("SHARED_TEST_RESOURCES")).orElse((Object)"false").map(str -> {
            if (str.isEmpty()) {
                return true;
            }
            return Boolean.parseBoolean(str);
        }));
        testResources.getSharedServerNamespace().convention(providers.environmentVariable("SHARED_TEST_RESOURCES_NAMESPACE"));
        return testResources;
    }

    private static boolean isAtLeastMicronaut3dot5(String v) {
        String[] parts = v.split("\\.");
        if (parts.length >= 2) {
            int major = Integer.parseInt(parts[0]);
            int minor = Integer.parseInt(parts[1]);
            return major > 3 || major == 3 && minor >= 5;
        }
        return false;
    }

    private Provider<List<Dependency>> buildTestResourcesDependencyList(Project project, DependencyHandler dependencies, TestResourcesConfiguration config, SourceSet testResourcesSourceSet) {
        return config.getEnabled().zip(config.getInferClasspath(), (enabled, infer) -> {
            if (Boolean.FALSE.equals(enabled)) {
                return Collections.singletonList(dependencies.create((Object)testResourcesSourceSet.getRuntimeClasspath()));
            }
            List mavenDependencies = Collections.emptyList();
            if (Boolean.TRUE.equals(infer)) {
                mavenDependencies = project.getConfigurations().getByName("runtimeClasspath").getAllDependencies().stream().filter(ModuleDependency.class::isInstance).map(ModuleDependency.class::cast).map(d -> new MavenDependency(d.getGroup(), d.getName(), d.getVersion())).collect(Collectors.toList());
            }
            String testResourcesVersion = (String)config.getVersion().get();
            return Stream.concat(Stream.concat(TestResourcesClasspath.inferTestResourcesClasspath(mavenDependencies, (String)testResourcesVersion).stream().map(Object::toString), ((List)config.getAdditionalModules().getOrElse(Collections.emptyList())).stream().map(m -> "io.micronaut.testresources:micronaut-test-resources-" + m + ":" + testResourcesVersion)).map(arg_0 -> ((DependencyHandler)dependencies).create(arg_0)), Stream.of(dependencies.create((Object)testResourcesSourceSet.getRuntimeClasspath()))).collect(Collectors.toList());
        }).orElse(Collections.emptyList());
    }

    private void configureServiceReset(final ProjectInternal project, final Provider<Directory> settingsDirectory, final Path shouldStopFile) {
        ServiceRegistry services = project.getServices();
        ListenerManager listenerManager = (ListenerManager)services.get(ListenerManager.class);
        try {
            Field parentField = listenerManager.getClass().getDeclaredField("parent");
            parentField.setAccessible(true);
            listenerManager = (ListenerManager)parentField.get(parentField.get(listenerManager));
            listenerManager.addListener((Object)new BuildSessionLifecycleListener(){

                public void beforeComplete() {
                    try {
                        if (Files.exists(shouldStopFile, new LinkOption[0])) {
                            project.getLogger().debug("Stop file contains " + Files.readAllLines(shouldStopFile));
                            if (Boolean.parseBoolean(Files.readAllLines(shouldStopFile).get(0))) {
                                ServerUtils.stopServer((Path)((Directory)settingsDirectory.get()).getAsFile().toPath());
                            }
                        }
                    }
                    catch (IOException e) {
                        project.getLogger().debug("Test resources server is already stopped", (Throwable)e);
                    }
                }
            });
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new GradleException(e.getMessage(), (Throwable)e);
        }
    }

    private static Configuration createTestResourcesServerConfiguration(Project project) {
        Configuration legacyConf = (Configuration)project.getConfigurations().create("testresources", conf -> {
            conf.setCanBeConsumed(false);
            conf.setCanBeResolved(false);
            conf.setDescription("[deprecated] Please use testResourcesService instead.");
        });
        return (Configuration)project.getConfigurations().create(TESTRESOURCES_CONFIGURATION, conf -> {
            conf.extendsFrom(new Configuration[]{legacyConf});
            conf.setDescription("Dependencies for the Micronaut test resources service");
            conf.setCanBeConsumed(false);
            conf.setCanBeResolved(true);
        });
    }

    private static Configuration createTestResourcesOutgoingConfiguration(Project project) {
        return (Configuration)project.getConfigurations().create(TESTRESOURCES_ELEMENTS_CONFIGURATION, conf -> {
            conf.setDescription("Provides the Micronaut Test Resources client configuration files");
            conf.setCanBeConsumed(true);
            conf.setCanBeResolved(false);
            conf.attributes(attr -> attr.attribute(Usage.USAGE_ATTRIBUTE, (Object)project.getObjects().named(Usage.class, MICRONAUT_TEST_RESOURCES_USAGE)));
        });
    }
}

