/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.openapi;

import java.io.Serializable;

public final class ParameterMappingModel
implements Serializable {
    private final String name;
    private final ParameterLocation location;
    private final String mappedType;
    private final String mappedName;
    private final boolean isValidated;

    public ParameterMappingModel(String name, ParameterLocation location, String mappedType) {
        this(name, location, mappedType, null, false);
    }

    private ParameterMappingModel(String name, ParameterLocation location, String mappedType, String mappedName, boolean isValidated) {
        this.name = name;
        this.location = location;
        this.mappedType = mappedType;
        this.mappedName = mappedName;
        this.isValidated = isValidated;
    }

    public ParameterMappingModel withName(String name) {
        return new ParameterMappingModel(name, this.location, this.mappedType, this.mappedName, this.isValidated);
    }

    public ParameterMappingModel withLocation(ParameterLocation location) {
        return new ParameterMappingModel(this.name, location, this.mappedType, this.mappedName, this.isValidated);
    }

    public ParameterMappingModel withMappedType(String mappedType) {
        return new ParameterMappingModel(this.name, this.location, mappedType, this.mappedName, this.isValidated);
    }

    public ParameterMappingModel withMappedName(String mappedName) {
        return new ParameterMappingModel(this.name, this.location, this.mappedType, mappedName, this.isValidated);
    }

    public ParameterMappingModel withValidated(boolean isValidated) {
        return new ParameterMappingModel(this.name, this.location, this.mappedType, this.mappedName, isValidated);
    }

    public String getName() {
        return this.name;
    }

    public ParameterLocation getLocation() {
        return this.location;
    }

    public String getMappedType() {
        return this.mappedType;
    }

    public String getMappedName() {
        return this.mappedName;
    }

    public boolean isValidated() {
        return this.isValidated;
    }

    public static enum ParameterLocation {
        HEADER,
        QUERY,
        FORM,
        COOKIE,
        BODY;

    }
}

