/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.docker;

import com.bmuschko.gradle.docker.DockerExtension;
import com.bmuschko.gradle.docker.tasks.container.DockerCopyFileFromContainer;
import com.bmuschko.gradle.docker.tasks.container.DockerCreateContainer;
import com.bmuschko.gradle.docker.tasks.container.DockerRemoveContainer;
import com.bmuschko.gradle.docker.tasks.image.DockerBuildImage;
import com.bmuschko.gradle.docker.tasks.image.DockerPushImage;
import com.bmuschko.gradle.docker.tasks.image.Dockerfile;
import io.micronaut.gradle.MicronautBasePlugin;
import io.micronaut.gradle.MicronautExtension;
import io.micronaut.gradle.MicronautRuntime;
import io.micronaut.gradle.PluginsHelper;
import io.micronaut.gradle.Strings;
import io.micronaut.gradle.docker.DockerBuildStrategy;
import io.micronaut.gradle.docker.MicronautDockerfile;
import io.micronaut.gradle.docker.NativeImageDockerfile;
import io.micronaut.gradle.docker.model.DefaultMicronautDockerImage;
import io.micronaut.gradle.docker.model.Layer;
import io.micronaut.gradle.docker.model.LayerKind;
import io.micronaut.gradle.docker.model.MicronautDockerImage;
import io.micronaut.gradle.docker.model.RuntimeKind;
import io.micronaut.gradle.docker.tasks.BuildLayersTask;
import io.micronaut.gradle.docker.tasks.PrepareDockerContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import org.graalvm.buildtools.gradle.dsl.NativeImageOptions;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaApplication;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;

public class MicronautDockerPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(MicronautBasePlugin.class);
        TaskContainer tasks = project.getTasks();
        ExtensionContainer extensions = project.getExtensions();
        MicronautExtension micronautExtension = (MicronautExtension)extensions.getByType(MicronautExtension.class);
        NamedDomainObjectContainer dockerImages = project.getObjects().domainObjectContainer(MicronautDockerImage.class, s -> (DefaultMicronautDockerImage)project.getObjects().newInstance(DefaultMicronautDockerImage.class, new Object[]{s}));
        micronautExtension.getExtensions().add("dockerImages", (Object)dockerImages);
        extensions.create("docker", DockerExtension.class, new Object[0]);
        dockerImages.all(image -> this.createDockerImage(project, (MicronautDockerImage)image));
        TaskProvider<Jar> runnerJar = this.createMainRunnerJar(project, tasks);
        dockerImages.create("main", image -> {
            image.addLayer((Action<? super Layer>)((Action)layer -> {
                layer.getLayerKind().set((Object)LayerKind.APP);
                layer.getFiles().from(new Object[]{runnerJar});
            }));
            image.addLayer((Action<? super Layer>)((Action)layer -> {
                layer.getLayerKind().set((Object)LayerKind.LIBS);
                layer.getFiles().from(new Object[]{project.getConfigurations().getByName("runtimeClasspath")});
            }));
            image.addLayer((Action<? super Layer>)((Action)layer -> {
                layer.getLayerKind().set((Object)LayerKind.EXPANDED_RESOURCES);
                layer.getFiles().from(new Object[]{((SourceSet)((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("main")).getOutput().getResourcesDir()});
            }));
        });
    }

    private static String simpleNameOf(String appendix, String context) {
        if ("main".equals(context)) {
            return appendix;
        }
        return context + "-" + appendix;
    }

    private static String adaptTaskName(String baseName, String context) {
        if ("main".equals(context)) {
            return baseName;
        }
        return context + Strings.capitalize((String)baseName);
    }

    private void createDockerImage(Project project, MicronautDockerImage imageSpec) {
        TaskContainer tasks = project.getTasks();
        String imageName = imageSpec.getName();
        project.getLogger().info("Creating docker tasks for image " + imageName);
        TaskProvider buildLayersTask = tasks.register(MicronautDockerPlugin.adaptTaskName("buildLayers", imageName), BuildLayersTask.class, task -> {
            task.setGroup("build");
            task.setDescription("Builds application layers for use in a Docker container (" + imageName + " image)");
            task.getLayers().set(imageSpec.findLayers(RuntimeKind.JIT));
            task.getOutputDir().convention(project.getLayout().getBuildDirectory().dir("docker/" + imageName + "/layers"));
        });
        tasks.configureEach(task -> {
            if ("assemble".equals(task.getName())) {
                task.dependsOn(new Object[]{buildLayersTask});
            }
        });
        Optional<TaskProvider<MicronautDockerfile>> dockerFileTask = this.configureDockerBuild(project, tasks, (TaskProvider<BuildLayersTask>)buildLayersTask, imageName);
        project.getPlugins().withId("io.micronaut.graalvm", plugin -> {
            TaskProvider buildNativeLayersTask = tasks.register(MicronautDockerPlugin.adaptTaskName("buildNativeLayersTask", imageName), BuildLayersTask.class, task -> {
                task.setGroup("build");
                task.setDescription("Builds application layers for use in a Docker container (" + imageName + " image)");
                task.getLayers().set(imageSpec.findLayers(RuntimeKind.NATIVE));
                task.getOutputDir().convention(project.getLayout().getBuildDirectory().dir("docker/native-" + imageName + "/layers"));
            });
            TaskProvider<NativeImageDockerfile> nativeImageDockerFileTask = this.configureNativeDockerBuild(project, tasks, (TaskProvider<BuildLayersTask>)buildNativeLayersTask, imageName);
            this.withBuildStrategy(project, buildStrategy -> nativeImageDockerFileTask.configure(it -> {
                buildStrategy.ifPresent(bs -> it.getBuildStrategy().set(buildStrategy.get()));
                it.setupNativeImageTaskPostEvaluate();
            }));
        });
        this.withBuildStrategy(project, buildStrategy -> dockerFileTask.ifPresent(t -> t.configure(it -> {
            buildStrategy.ifPresent(bs -> it.getBuildStrategy().set(buildStrategy.get()));
            it.setupTaskPostEvaluate();
        })));
    }

    private void withBuildStrategy(Project project, Consumer<? super Optional<DockerBuildStrategy>> action) {
        project.afterEvaluate(eval -> {
            MicronautRuntime mr = PluginsHelper.resolveRuntime((Project)project);
            Optional<Object> buildStrategy = mr != MicronautRuntime.NONE ? Optional.of(mr.getBuildStrategy()) : Optional.empty();
            action.accept(buildStrategy);
        });
    }

    private TaskProvider<Jar> createMainRunnerJar(Project project, TaskContainer tasks) {
        return tasks.register("runnerJar", Jar.class, jar -> {
            jar.dependsOn(new Object[]{tasks.findByName("classes")});
            jar.getArchiveClassifier().set((Object)"runner");
            SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
            SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
            FileCollection dirs = mainSourceSet.getOutput().getClassesDirs();
            jar.from(new Object[]{dirs});
            jar.manifest(manifest -> {
                HashMap<String, Object> attrs = new HashMap<String, Object>(2);
                JavaApplication javaApplication = (JavaApplication)project.getExtensions().getByType(JavaApplication.class);
                attrs.put("Main-Class", javaApplication.getMainClass());
                attrs.put("Class-Path", project.getProviders().provider(() -> {
                    ArrayList<String> classpath = new ArrayList<String>();
                    Configuration runtimeClasspath = project.getConfigurations().getByName("runtimeClasspath");
                    classpath.add("resources/");
                    classpath.add("classes/");
                    for (File file : runtimeClasspath) {
                        classpath.add("libs/" + file.getName());
                    }
                    return String.join((CharSequence)" ", classpath);
                }));
                manifest.attributes(attrs);
            });
        });
    }

    private Optional<TaskProvider<MicronautDockerfile>> configureDockerBuild(Project project, TaskContainer tasks, TaskProvider<BuildLayersTask> buildLayersTask, String imageName) {
        File f = project.file((Object)MicronautDockerPlugin.adaptTaskName("Dockerfile", imageName));
        String dockerFileTaskName = MicronautDockerPlugin.adaptTaskName("dockerfile", imageName);
        Provider targetDockerFile = project.getLayout().getBuildDirectory().file("docker/" + imageName + "/Dockerfile");
        TaskProvider dockerFileTask = f.exists() ? tasks.register(dockerFileTaskName, Dockerfile.class, task -> {
            task.setGroup("build");
            task.setDescription("Builds a Docker File for image " + imageName);
            task.getDestFile().set(targetDockerFile);
            task.instructionsFromTemplate(f);
        }) : tasks.register(dockerFileTaskName, MicronautDockerfile.class, task -> {
            task.setGroup("build");
            task.setDescription("Builds a Docker File for image " + imageName);
            task.getDestFile().set(targetDockerFile);
            task.setupDockerfileInstructions();
        });
        TaskProvider dockerBuildTask = tasks.register(MicronautDockerPlugin.adaptTaskName("dockerBuild", imageName), DockerBuildImage.class, task -> {
            task.dependsOn(new Object[]{buildLayersTask});
            task.setGroup("build");
            task.setDescription("Builds a Docker Image (image " + imageName + ")");
            if (f.exists()) {
                task.getDockerFile().set(f);
            } else {
                task.getDockerFile().convention(dockerFileTask.flatMap(Dockerfile::getDestFile));
            }
            task.getImages().set(Collections.singletonList(project.getName()));
            task.getInputDir().set(dockerFileTask.flatMap(Dockerfile::getDestDir));
        });
        TaskProvider pushDockerImage = tasks.register(MicronautDockerPlugin.adaptTaskName("dockerPush", imageName), DockerPushImage.class, task -> {
            task.dependsOn(new Object[]{dockerBuildTask});
            task.setGroup("upload");
            task.setDescription("Pushes the " + imageName + " Docker Image");
            task.getImages().set(dockerBuildTask.flatMap(DockerBuildImage::getImages));
        });
        if (!f.exists()) {
            return Optional.of(dockerFileTask);
        }
        return Optional.empty();
    }

    private TaskProvider<NativeImageDockerfile> configureNativeDockerBuild(Project project, TaskContainer tasks, TaskProvider<BuildLayersTask> buildLayersTask, String imageName) {
        File f = project.file((Object)MicronautDockerPlugin.adaptTaskName("DockerfileNative", imageName));
        String dockerfileNativeTaskName = MicronautDockerPlugin.adaptTaskName("dockerfileNative", imageName);
        Provider targetDockerFile = project.getLayout().getBuildDirectory().file("docker/native-" + imageName + "/DockerfileNative");
        TaskProvider dockerFileTask = f.exists() ? tasks.register(dockerfileNativeTaskName, NativeImageDockerfile.class, task -> {
            task.setGroup("build");
            task.setDescription("Builds a Native Docker File for image " + imageName);
            task.instructionsFromTemplate(f);
            task.getDestFile().set(targetDockerFile);
        }) : tasks.register(dockerfileNativeTaskName, NativeImageDockerfile.class, task -> {
            task.setGroup("build");
            task.setDescription("Builds a Native Docker File for image " + imageName);
            task.getDestFile().set(targetDockerFile);
        });
        TaskProvider prepareContext = tasks.register(MicronautDockerPlugin.adaptTaskName("dockerPrepareContext", imageName), PrepareDockerContext.class, context -> {
            context.getOutputDirectory().set(project.getLayout().getBuildDirectory().dir("docker/native-" + imageName + "/config-dirs"));
            context.getInputDirectories().from(new Object[]{dockerFileTask.map(t -> ((NativeImageOptions)t.getNativeImageOptions().get()).getConfigurationFileDirectories())});
        });
        TaskProvider dockerBuildTask = tasks.register(MicronautDockerPlugin.adaptTaskName("dockerBuildNative", imageName), DockerBuildImage.class, task -> {
            task.setGroup("build");
            task.setDescription("Builds a Native Docker Image using GraalVM (image " + imageName + ")");
            task.getInputs().files(new Object[]{prepareContext});
            if (f.exists()) {
                task.getDockerFile().set(f);
            } else {
                task.getDockerFile().convention(dockerFileTask.flatMap(Dockerfile::getDestFile));
            }
            task.getImages().set(Collections.singletonList(project.getName()));
            task.dependsOn(new Object[]{buildLayersTask});
            task.getInputDir().set(dockerFileTask.flatMap(Dockerfile::getDestDir));
        });
        TaskProvider pushDockerImage = tasks.register(MicronautDockerPlugin.adaptTaskName("dockerPushNative", imageName), DockerPushImage.class);
        pushDockerImage.configure(task -> {
            task.dependsOn(new Object[]{dockerBuildTask});
            task.setGroup("upload");
            task.setDescription("Pushes a Native Docker Image using GraalVM (image " + imageName + ")");
            task.getImages().set(dockerBuildTask.flatMap(DockerBuildImage::getImages));
        });
        project.afterEvaluate(p -> {
            MicronautRuntime mr = PluginsHelper.resolveRuntime((Project)p);
            if (mr.isLambdaProvided()) {
                TaskContainer taskContainer = p.getTasks();
                TaskProvider createLambdaContainer = taskContainer.register(MicronautDockerPlugin.adaptTaskName("createLambdaContainer", imageName), DockerCreateContainer.class, task -> {
                    task.dependsOn(new Object[]{dockerBuildTask});
                    task.targetImageId(dockerBuildTask.flatMap(DockerBuildImage::getImageId));
                });
                TaskProvider buildLambdaZip = taskContainer.register(MicronautDockerPlugin.adaptTaskName("buildNativeLambda", imageName), DockerCopyFileFromContainer.class);
                final Provider lambdaZip = project.getLayout().getBuildDirectory().dir("libs").map(dir -> dir.file(project.getName() + "-" + project.getVersion() + "-" + MicronautDockerPlugin.simpleNameOf("lambda", imageName) + ".zip").getAsFile().getAbsolutePath());
                TaskProvider removeContainer = taskContainer.register(MicronautDockerPlugin.adaptTaskName("destroyLambdaContainer", imageName), DockerRemoveContainer.class);
                removeContainer.configure(task -> {
                    task.mustRunAfter(new Object[]{buildLambdaZip});
                    task.getContainerId().set(createLambdaContainer.flatMap(DockerCreateContainer::getContainerId));
                });
                buildLambdaZip.configure(task -> {
                    task.dependsOn(new Object[]{createLambdaContainer});
                    task.getContainerId().set(createLambdaContainer.flatMap(DockerCreateContainer::getContainerId));
                    task.getRemotePath().set((Object)"/function/function.zip");
                    task.getHostPath().set(lambdaZip);
                    task.doLast((Action)new Action<Task>(){

                        public void execute(Task task1) {
                            System.out.println("AWS Lambda ZIP built: " + (String)lambdaZip.get());
                        }
                    });
                    task.finalizedBy(new Object[]{removeContainer});
                });
            }
        });
        return dockerFileTask;
    }
}

