/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.elasticsearch.health;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.endpoint.health.HealthEndpoint;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.reactivestreams.Publisher;

@Requirements(value={@Requires(beans={HealthEndpoint.class}), @Requires(property="endpoints.health.elasticsearch.rest.high.level.enabled", notEquals="false")})
@Singleton
public class ElasticsearchHealthIndicator
implements HealthIndicator {
    private static final String NAME = "elasticsearch";
    private final RestHighLevelClient esClient;

    public ElasticsearchHealthIndicator(RestHighLevelClient esClient) {
        this.esClient = esClient;
    }

    public Publisher<HealthResult> getResult() {
        return subscriber -> this.esClient.cluster().healthAsync(new ClusterHealthRequest(), RequestOptions.DEFAULT, (ActionListener)new ActionListener<ClusterHealthResponse>(){
            private final HealthResult.Builder resultBuilder = HealthResult.builder((String)"elasticsearch");

            public void onResponse(ClusterHealthResponse response) {
                HealthResult result;
                try {
                    result = this.resultBuilder.status(ElasticsearchHealthIndicator.this.healthResultStatus(response)).details((Object)ElasticsearchHealthIndicator.this.healthResultDetails(response)).build();
                }
                catch (IOException e) {
                    result = this.resultBuilder.status(HealthStatus.DOWN).exception((Throwable)e).build();
                }
                subscriber.onNext((Object)result);
                subscriber.onComplete();
            }

            public void onFailure(Exception e) {
                subscriber.onNext((Object)this.resultBuilder.status(HealthStatus.DOWN).exception((Throwable)e).build());
                subscriber.onComplete();
            }
        });
    }

    private String healthResultDetails(ClusterHealthResponse response) throws IOException {
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
        response.toXContent(xContentBuilder, (ToXContent.Params)new ToXContent.MapParams(Collections.emptyMap()));
        return Strings.toString((XContentBuilder)xContentBuilder);
    }

    private HealthStatus healthResultStatus(ClusterHealthResponse response) {
        return response.getStatus() == ClusterHealthStatus.GREEN || response.getStatus() == ClusterHealthStatus.YELLOW ? HealthStatus.UP : HealthStatus.DOWN;
    }
}

