/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.elasticsearch;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.elasticsearch.DefaultElasticsearchConfigurationProperties;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

@Requires(beans={DefaultElasticsearchConfigurationProperties.class})
@Factory
public class DefaultElasticsearchClientFactory {
    @Bean(preDestroy="close")
    RestHighLevelClient restHighLevelClient(DefaultElasticsearchConfigurationProperties elasticsearchConfiguration) {
        return new RestHighLevelClient(this.restClientBuilder(elasticsearchConfiguration));
    }

    @Bean(preDestroy="close")
    RestClient restClient(DefaultElasticsearchConfigurationProperties elasticsearchConfiguration) {
        return this.restClientBuilder(elasticsearchConfiguration).build();
    }

    protected RestClientBuilder restClientBuilder(DefaultElasticsearchConfigurationProperties elasticsearchConfiguration) {
        return RestClient.builder((HttpHost[])elasticsearchConfiguration.getHttpHosts()).setRequestConfigCallback(requestConfigBuilder -> {
            requestConfigBuilder = elasticsearchConfiguration.requestConfigBuilder;
            return requestConfigBuilder;
        }).setHttpClientConfigCallback(httpClientBuilder -> {
            httpClientBuilder = elasticsearchConfiguration.httpAsyncClientBuilder;
            return httpClientBuilder;
        });
    }
}

