/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.support;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.support.ResourceHolder;
import io.micronaut.transaction.support.TransactionSynchronization;
import io.micronaut.transaction.support.TransactionSynchronizationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransactionSynchronizationManager {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionSynchronizationManager.class);
    private static final ThreadLocal<Map<Object, Object>> RESOURCES = new ThreadLocal(){

        public String toString() {
            return "Transactional resources";
        }
    };
    private static final ThreadLocal<Set<TransactionSynchronization>> SYNCHRONIZATIONS = new ThreadLocal(){

        public String toString() {
            return "Transaction synchronizations";
        }
    };
    private static final ThreadLocal<String> CURRENT_TRANSACTION_NAME = new ThreadLocal(){

        public String toString() {
            return "Current transaction name";
        }
    };
    private static final ThreadLocal<Boolean> CURRENT_TRANSACTION_READ_ONLY = new ThreadLocal(){

        public String toString() {
            return "Current transaction read-only status";
        }
    };
    private static final ThreadLocal<TransactionDefinition.Isolation> CURRENT_TRANSACTION_ISOLATION_LEVEL = new ThreadLocal(){

        public String toString() {
            return "Current transaction isolation level";
        }
    };
    private static final ThreadLocal<Boolean> ACTUAL_TRANSACTION_ACTIVE = new ThreadLocal(){

        public String toString() {
            return "Actual transaction active";
        }
    };

    public static Map<Object, Object> getResourceMap() {
        Map<Object, Object> map = RESOURCES.get();
        return map != null ? Collections.unmodifiableMap(map) : Collections.emptyMap();
    }

    public static boolean hasResource(Object key) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        Object value = TransactionSynchronizationManager.doGetResource(actualKey);
        return value != null;
    }

    @Nullable
    public static Object getResource(Object key) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        Object value = TransactionSynchronizationManager.doGetResource(actualKey);
        if (value != null && LOG.isTraceEnabled()) {
            LOG.trace("Retrieved value [" + value + "] for key [" + actualKey + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        return value;
    }

    @Nullable
    private static Object doGetResource(Object actualKey) {
        Map<Object, Object> map = RESOURCES.get();
        if (map == null) {
            return null;
        }
        Object value = map.get(actualKey);
        if (value instanceof ResourceHolder && ((ResourceHolder)value).isVoid()) {
            map.remove(actualKey);
            if (map.isEmpty()) {
                RESOURCES.remove();
            }
            value = null;
        }
        return value;
    }

    public static void bindResource(Object key, Object value) throws IllegalStateException {
        Object oldValue;
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        Objects.requireNonNull(value, "Value must not be null");
        Map<Object, Object> map = RESOURCES.get();
        if (map == null) {
            map = new HashMap<Object, Object>();
            RESOURCES.set(map);
        }
        if ((oldValue = map.put(actualKey, value)) instanceof ResourceHolder && ((ResourceHolder)oldValue).isVoid()) {
            oldValue = null;
        }
        if (oldValue != null) {
            throw new IllegalStateException("Already value [" + oldValue + "] for key [" + actualKey + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Bound value [" + value + "] for key [" + actualKey + "] to thread [" + Thread.currentThread().getName() + "]");
        }
    }

    public static Object unbindResource(Object key) throws IllegalStateException {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        Object value = TransactionSynchronizationManager.doUnbindResource(actualKey);
        if (value == null) {
            throw new IllegalStateException("No value for key [" + actualKey + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        return value;
    }

    @Nullable
    public static Object unbindResourceIfPossible(Object key) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        return TransactionSynchronizationManager.doUnbindResource(actualKey);
    }

    @Nullable
    private static Object doUnbindResource(Object actualKey) {
        Map<Object, Object> map = RESOURCES.get();
        if (map == null) {
            return null;
        }
        Object value = map.remove(actualKey);
        if (map.isEmpty()) {
            RESOURCES.remove();
        }
        if (value instanceof ResourceHolder && ((ResourceHolder)value).isVoid()) {
            value = null;
        }
        if (value != null && LOG.isTraceEnabled()) {
            LOG.trace("Removed value [" + value + "] for key [" + actualKey + "] from thread [" + Thread.currentThread().getName() + "]");
        }
        return value;
    }

    public static boolean isSynchronizationActive() {
        return SYNCHRONIZATIONS.get() != null;
    }

    public static void initSynchronization() throws IllegalStateException {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Cannot activate transaction synchronization - already active");
        }
        LOG.trace("Initializing transaction synchronization");
        SYNCHRONIZATIONS.set(new LinkedHashSet());
    }

    public static void registerSynchronization(TransactionSynchronization synchronization) throws IllegalStateException {
        Objects.requireNonNull(synchronization, "TransactionSynchronization must not be null");
        Set<TransactionSynchronization> synchs = SYNCHRONIZATIONS.get();
        if (synchs == null) {
            throw new IllegalStateException("Transaction synchronization is not active");
        }
        synchs.add(synchronization);
    }

    public static List<TransactionSynchronization> getSynchronizations() throws IllegalStateException {
        Set<TransactionSynchronization> synchs = SYNCHRONIZATIONS.get();
        if (synchs == null) {
            throw new IllegalStateException("Transaction synchronization is not active");
        }
        if (synchs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TransactionSynchronization> sortedSynchs = new ArrayList<TransactionSynchronization>(synchs);
        OrderUtil.sort(sortedSynchs);
        return Collections.unmodifiableList(sortedSynchs);
    }

    public static void clearSynchronization() throws IllegalStateException {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Cannot deactivate transaction synchronization - not active");
        }
        LOG.trace("Clearing transaction synchronization");
        SYNCHRONIZATIONS.remove();
    }

    public static void setCurrentTransactionName(@Nullable String name) {
        CURRENT_TRANSACTION_NAME.set(name);
    }

    @Nullable
    public static String getCurrentTransactionName() {
        return CURRENT_TRANSACTION_NAME.get();
    }

    public static void setCurrentTransactionReadOnly(boolean readOnly) {
        CURRENT_TRANSACTION_READ_ONLY.set(readOnly ? Boolean.TRUE : null);
    }

    public static boolean isCurrentTransactionReadOnly() {
        return CURRENT_TRANSACTION_READ_ONLY.get() != null;
    }

    public static void setCurrentTransactionIsolationLevel(@Nullable TransactionDefinition.Isolation isolationLevel) {
        CURRENT_TRANSACTION_ISOLATION_LEVEL.set(isolationLevel);
    }

    @Nullable
    public static TransactionDefinition.Isolation getCurrentTransactionIsolationLevel() {
        return CURRENT_TRANSACTION_ISOLATION_LEVEL.get();
    }

    public static void setActualTransactionActive(boolean active) {
        ACTUAL_TRANSACTION_ACTIVE.set(active ? Boolean.TRUE : null);
    }

    public static boolean isActualTransactionActive() {
        return ACTUAL_TRANSACTION_ACTIVE.get() != null;
    }

    public static void clear() {
        SYNCHRONIZATIONS.remove();
        CURRENT_TRANSACTION_NAME.remove();
        CURRENT_TRANSACTION_READ_ONLY.remove();
        CURRENT_TRANSACTION_ISOLATION_LEVEL.remove();
        ACTUAL_TRANSACTION_ACTIVE.remove();
    }

    @Internal
    public static State copyState() {
        return new CopyState(RESOURCES.get(), SYNCHRONIZATIONS.get(), CURRENT_TRANSACTION_NAME.get(), CURRENT_TRANSACTION_READ_ONLY.get(), CURRENT_TRANSACTION_ISOLATION_LEVEL.get(), ACTUAL_TRANSACTION_ACTIVE.get());
    }

    @Internal
    public static void restoreState(State state) {
        if (!(state instanceof CopyState)) {
            throw new IllegalStateException("Unknown state: " + state);
        }
        CopyState copyState = (CopyState)state;
        RESOURCES.set(copyState.resources == null ? null : new HashMap(copyState.resources));
        SYNCHRONIZATIONS.set(copyState.synchronizations == null ? null : new LinkedHashSet(copyState.synchronizations));
        CURRENT_TRANSACTION_NAME.set(copyState.currentTransactionName);
        CURRENT_TRANSACTION_READ_ONLY.set(copyState.currentTransactionReadOnlyStatus);
        CURRENT_TRANSACTION_ISOLATION_LEVEL.set(copyState.currentTransactionIsolationLevel);
        ACTUAL_TRANSACTION_ACTIVE.set(copyState.actualTransactionActive);
    }

    private static final class CopyState
    implements State {
        private final Map<Object, Object> resources;
        private final Set<TransactionSynchronization> synchronizations;
        private final String currentTransactionName;
        private final Boolean currentTransactionReadOnlyStatus;
        private final TransactionDefinition.Isolation currentTransactionIsolationLevel;
        private final Boolean actualTransactionActive;

        private CopyState(Map<Object, Object> resources, Set<TransactionSynchronization> synchronizations, String currentTransactionName, Boolean currentTransactionReadOnlyStatus, TransactionDefinition.Isolation currentTransactionIsolationLevel, Boolean actualTransactionActive) {
            this.resources = resources == null ? null : new HashMap<Object, Object>(resources);
            this.synchronizations = synchronizations == null ? null : new LinkedHashSet<TransactionSynchronization>(synchronizations);
            this.currentTransactionName = currentTransactionName;
            this.currentTransactionReadOnlyStatus = currentTransactionReadOnlyStatus;
            this.currentTransactionIsolationLevel = currentTransactionIsolationLevel;
            this.actualTransactionActive = actualTransactionActive;
        }
    }

    @Internal
    public static interface State {
    }
}

