/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.interceptor;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.transaction.interceptor.TransactionAttribute;
import io.micronaut.transaction.support.DefaultTransactionDefinition;
import java.util.Set;

public class DefaultTransactionAttribute
extends DefaultTransactionDefinition
implements TransactionAttribute {
    private String qualifier;
    private Set<Class<? extends Throwable>> noRollbackFor;

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public void setNoRollbackFor(Class<? extends Throwable> ... noRollbackFor) {
        if (ArrayUtils.isNotEmpty((Object[])noRollbackFor)) {
            this.noRollbackFor = CollectionUtils.setOf((Object[])noRollbackFor);
        }
    }

    @Override
    @Nullable
    public String getQualifier() {
        return this.qualifier;
    }

    @Override
    public boolean rollbackOn(Throwable ex) {
        if (this.noRollbackFor == null) {
            return true;
        }
        return this.noRollbackFor.stream().noneMatch(t -> t.isInstance(ex));
    }
}

