/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.exceptions;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.transaction.exceptions.TransactionException;
import java.util.Objects;

public class TransactionSystemException
extends TransactionException {
    @Nullable
    private Throwable applicationException;

    public TransactionSystemException(String msg) {
        super(msg);
    }

    public TransactionSystemException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public void initApplicationException(Throwable ex) {
        Objects.requireNonNull(ex, "Application exception must not be null");
        if (this.applicationException != null) {
            throw new IllegalStateException("Already holding an application exception: " + this.applicationException);
        }
        this.applicationException = ex;
    }

    @Nullable
    public final Throwable getApplicationException() {
        return this.applicationException;
    }

    @Nullable
    public Throwable getOriginalException() {
        return this.applicationException != null ? this.applicationException : this.getCause();
    }
}

