/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.test;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Requires;
import io.micronaut.test.transaction.TestTransactionInterceptor;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionStatus;
import java.util.concurrent.atomic.AtomicInteger;

@EachBean(value=SynchronousTransactionManager.class)
@Requires(classes={TestTransactionInterceptor.class})
public class DefaultTestTransactionInterceptor
implements TestTransactionInterceptor {
    private final SynchronousTransactionManager transactionManager;
    private TransactionStatus<?> tx;
    private final AtomicInteger counter = new AtomicInteger();

    protected DefaultTestTransactionInterceptor(SynchronousTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void begin() {
        if (this.counter.getAndIncrement() == 0) {
            this.tx = this.transactionManager.getTransaction(TransactionDefinition.DEFAULT);
        }
    }

    public void commit() {
        if (this.counter.decrementAndGet() == 0) {
            this.transactionManager.commit(this.tx);
        }
    }

    public void rollback() {
        if (this.counter.decrementAndGet() == 0) {
            this.transactionManager.rollback(this.tx);
        }
    }
}

