/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.spring.runtime;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.model.Sort;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

@Internal
class PageDelegate<T>
implements Page<T> {
    private final io.micronaut.data.model.Page<T> delegate;

    PageDelegate(io.micronaut.data.model.Page<T> delegate) {
        this.delegate = delegate;
    }

    public int getNumber() {
        return this.delegate.getPageNumber();
    }

    public int getSize() {
        return this.delegate.getSize();
    }

    public int getTotalPages() {
        return this.delegate.getTotalPages();
    }

    public int getNumberOfElements() {
        return this.delegate.getNumberOfElements();
    }

    public long getTotalElements() {
        return this.delegate.getTotalSize();
    }

    public <U> Page<U> map(Function<? super T, ? extends U> converter) {
        return new PageDelegate<T>(io.micronaut.data.model.Page.of(this.getContent().stream().map(converter).collect(Collectors.toList()), (io.micronaut.data.model.Pageable)this.delegate.getPageable(), (Long)this.delegate.getTotalSize()));
    }

    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    public List<T> getContent() {
        return this.delegate.getContent();
    }

    public boolean hasContent() {
        return !this.delegate.isEmpty();
    }

    public org.springframework.data.domain.Sort getSort() {
        List orderBy = this.delegate.getSort().getOrderBy();
        if (CollectionUtils.isEmpty((Collection)orderBy)) {
            return org.springframework.data.domain.Sort.unsorted();
        }
        return new SortDelegate(this.delegate.getSort());
    }

    public boolean isFirst() {
        return !this.hasPrevious();
    }

    public boolean isLast() {
        return !this.hasNext();
    }

    public boolean hasNext() {
        return this.getNumber() + 1 < this.getTotalPages();
    }

    public boolean hasPrevious() {
        return this.getNumber() > 0;
    }

    public Pageable nextPageable() {
        return new PageableDelegate(this.delegate.nextPageable());
    }

    public Pageable previousPageable() {
        return new PageableDelegate(this.delegate.previousPageable());
    }

    private class SortDelegate
    extends org.springframework.data.domain.Sort {
        private final Sort delegate;

        SortDelegate(Sort delegate) {
            super(Collections.emptyList());
            this.delegate = delegate;
        }

        public org.springframework.data.domain.Sort and(org.springframework.data.domain.Sort sort) {
            for (Sort.Order order : sort) {
                this.delegate.order(order.getProperty(), Sort.Order.Direction.valueOf((String)order.getDirection().name()));
            }
            return this;
        }

        public Sort.Order getOrderFor(String property) {
            return this.delegate.getOrderBy().stream().filter(o -> o.getProperty().equals(property)).map(order -> new Sort.Order(Sort.Direction.valueOf((String)order.getDirection().name()), order.getProperty())).findFirst().orElse(null);
        }

        public Iterator<Sort.Order> iterator() {
            final Iterator i = this.delegate.getOrderBy().iterator();
            return new Iterator<Sort.Order>(this){

                @Override
                public boolean hasNext() {
                    return i.hasNext();
                }

                @Override
                public Sort.Order next() {
                    Sort.Order next = (Sort.Order)i.next();
                    return new Sort.Order(Sort.Direction.valueOf((String)next.getDirection().name()), next.getProperty());
                }
            };
        }
    }

    private class PageableDelegate
    extends PageRequest {
        PageableDelegate(io.micronaut.data.model.Pageable pageable) {
            super(pageable.getNumber(), pageable.getSize(), (org.springframework.data.domain.Sort)new SortDelegate(pageable.getSort()));
        }
    }
}

