/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.spring.jpa.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.jpa.operations.JpaRepositoryOperations;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.query.QueryUtils;

@Internal
public class FindAllSpecificationInterceptor
extends AbstractQueryInterceptor<Object, Object> {
    private final JpaRepositoryOperations jpaOperations;

    protected FindAllSpecificationInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
        if (!(operations instanceof JpaRepositoryOperations)) {
            throw new IllegalStateException("Repository operations must be na instance of JpaRepositoryOperations");
        }
        this.jpaOperations = (JpaRepositoryOperations)operations;
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        Object[] parameterValues = context.getParameterValues();
        Object parameterValue = parameterValues[0];
        if (parameterValue instanceof Specification) {
            Sort sort;
            Specification specification = (Specification)parameterValue;
            EntityManager entityManager = this.jpaOperations.getCurrentEntityManager();
            CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
            CriteriaQuery query = criteriaBuilder.createQuery(this.getRequiredRootEntity(context));
            Root root = query.from(this.getRequiredRootEntity(context));
            Predicate predicate = specification.toPredicate(root, query, criteriaBuilder);
            if (predicate != null) {
                query.where((Expression)predicate);
            }
            query.select((Selection)root);
            if (parameterValues.length == 1) {
                TypedQuery typedQuery = entityManager.createQuery(query);
                return typedQuery.getResultList();
            }
            Object o = parameterValues[1];
            if (o instanceof Sort && (sort = (Sort)o).isSorted()) {
                List orders = QueryUtils.toOrders((Sort)sort, (From)root, (CriteriaBuilder)criteriaBuilder);
                query.orderBy(orders);
            }
            TypedQuery typedQuery = entityManager.createQuery(query);
            return typedQuery.getResultList();
        }
        throw new IllegalArgumentException("Argument must be an instance of: " + Specification.class);
    }
}

