/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.spring.jpa.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.ReturnType;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.jpa.operations.JpaRepositoryOperations;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import java.util.Collections;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.data.jpa.domain.Specification;

@Internal
public class CountSpecificationInterceptor
extends AbstractQueryInterceptor<Object, Number> {
    private final JpaRepositoryOperations jpaOperations;

    protected CountSpecificationInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
        if (!(operations instanceof JpaRepositoryOperations)) {
            throw new IllegalStateException("Repository operations must be na instance of JpaRepositoryOperations");
        }
        this.jpaOperations = (JpaRepositoryOperations)operations;
    }

    public Number intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Number> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof Specification) {
            Specification specification = (Specification)parameterValue;
            EntityManager entityManager = this.jpaOperations.getCurrentEntityManager();
            CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
            CriteriaQuery query = criteriaBuilder.createQuery(Long.class);
            Root root = query.from(this.getRequiredRootEntity(context));
            Predicate predicate = specification.toPredicate(root, query, criteriaBuilder);
            if (predicate != null) {
                query.where((Expression)predicate);
            }
            if (query.isDistinct()) {
                query.select((Selection)criteriaBuilder.countDistinct((Expression)root));
            } else {
                query.select((Selection)criteriaBuilder.count((Expression)root));
            }
            query.orderBy(Collections.emptyList());
            TypedQuery typedQuery = entityManager.createQuery(query);
            Long result = (Long)typedQuery.getSingleResult();
            ReturnType rt = context.getReturnType();
            Class returnType = rt.getType();
            if (returnType.isInstance(result)) {
                return result;
            }
            return (Number)ConversionService.SHARED.convertRequired((Object)result, rt.asArgument());
        }
        throw new IllegalArgumentException("Argument must be an instance of: " + Specification.class);
    }
}

