/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.spring.jdbc;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.data.connection.ConnectionOperations;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.data.connection.jdbc.advice.DelegatingDataSource;
import io.micronaut.data.connection.jdbc.operations.DefaultDataSourceConnectionOperations;
import io.micronaut.data.connection.support.DefaultConnectionStatus;
import java.sql.Connection;
import java.util.Optional;
import java.util.function.Function;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Internal
@EachBean(value=DataSource.class)
@Replaces(value=DefaultDataSourceConnectionOperations.class)
public final class SpringJdbcConnectionOperations
implements ConnectionOperations<Connection> {
    private final DataSource dataSource;

    public SpringJdbcConnectionOperations(DataSource dataSource) {
        this.dataSource = DelegatingDataSource.unwrapDataSource((DataSource)dataSource);
    }

    public Optional<ConnectionStatus<Connection>> findConnectionStatus() {
        ConnectionHandle connectionHandle;
        ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)this.dataSource);
        if (conHolder != null && (connectionHandle = conHolder.getConnectionHandle()) != null) {
            return Optional.of(this.createStatus(connectionHandle.getConnection()));
        }
        return Optional.empty();
    }

    public <R> R execute(ConnectionDefinition definition, Function<ConnectionStatus<Connection>, R> callback) {
        return (R)new JdbcTemplate(this.dataSource).execute(connection -> callback.apply((ConnectionStatus<Connection>)this.createStatus(connection)));
    }

    private DefaultConnectionStatus<Connection> createStatus(Connection connection) {
        return new DefaultConnectionStatus((Object)connection, ConnectionDefinition.DEFAULT, true);
    }
}

