/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.spring.tx;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.transaction.TransactionCallback;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionStatus;
import io.micronaut.transaction.support.AbstractPropagatedStatusTransactionOperations;
import io.micronaut.transaction.support.ExceptionUtil;
import io.micronaut.transaction.support.TransactionSynchronization;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

@Internal
public abstract class AbstractSpringTransactionOperations
extends AbstractPropagatedStatusTransactionOperations<TransactionStatus<Connection>, Connection> {
    private final PlatformTransactionManager transactionManager;
    private final TransactionTemplate writeTransactionTemplate;
    private final TransactionTemplate readTransactionTemplate;

    protected AbstractSpringTransactionOperations(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        this.writeTransactionTemplate = new TransactionTemplate(transactionManager);
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setReadOnly(true);
        this.readTransactionTemplate = new TransactionTemplate(transactionManager, (org.springframework.transaction.TransactionDefinition)transactionDefinition);
    }

    public <R> R executeRead(@NonNull TransactionCallback<Connection, R> callback) {
        return this.execute(this.readTransactionTemplate, callback, TransactionDefinition.READ_ONLY);
    }

    public <R> R executeWrite(@NonNull TransactionCallback<Connection, R> callback) {
        return this.execute(this.writeTransactionTemplate, callback, TransactionDefinition.DEFAULT);
    }

    protected <R> R doExecute(TransactionDefinition definition, TransactionCallback<Connection, R> callback) {
        ArgumentUtils.requireNonNull((String)"callback", callback);
        ArgumentUtils.requireNonNull((String)"definition", (Object)definition);
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        definition.isReadOnly().ifPresent(arg_0 -> ((DefaultTransactionDefinition)def).setReadOnly(arg_0));
        def.setIsolationLevel(definition.getIsolationLevel().orElse(TransactionDefinition.Isolation.DEFAULT).getCode());
        def.setPropagationBehavior(definition.getPropagationBehavior().ordinal());
        def.setName(definition.getName());
        definition.getTimeout().ifPresent(timeout -> {
            if (!timeout.isNegative()) {
                def.setTimeout((int)timeout.getSeconds());
            }
        });
        return this.execute(new TransactionTemplate(this.transactionManager, (org.springframework.transaction.TransactionDefinition)def), callback, definition);
    }

    private <R> R execute(TransactionTemplate template, TransactionCallback<Connection, R> callback, TransactionDefinition transactionDefinition) {
        ArgumentUtils.requireNonNull((String)"callback", callback);
        try {
            return (R)template.execute(status -> this.execute(callback, status, transactionDefinition));
        }
        catch (UndeclaredThrowableException e) {
            return (R)ExceptionUtil.sneakyThrow((Throwable)e.getUndeclaredThrowable());
        }
    }

    private <R> R execute(TransactionCallback<Connection, R> callback, org.springframework.transaction.TransactionStatus status, TransactionDefinition transactionDefinition) {
        SpringTransactionStatus txStatus = new SpringTransactionStatus(status, transactionDefinition);
        try {
            return (R)callback.call((TransactionStatus)txStatus);
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Exception e) {
            return (R)ExceptionUtil.sneakyThrow((Throwable)e);
        }
    }

    private final class SpringTransactionStatus
    implements TransactionStatus<Connection> {
        private final org.springframework.transaction.TransactionStatus springStatus;
        private final TransactionDefinition transactionDefinition;

        SpringTransactionStatus(org.springframework.transaction.TransactionStatus springStatus, TransactionDefinition transactionDefinition) {
            this.springStatus = springStatus;
            this.transactionDefinition = transactionDefinition;
        }

        public boolean isNewTransaction() {
            return this.springStatus.isNewTransaction();
        }

        public void setRollbackOnly() {
            this.springStatus.setRollbackOnly();
        }

        public boolean isRollbackOnly() {
            return this.springStatus.isRollbackOnly();
        }

        public boolean isCompleted() {
            return this.springStatus.isCompleted();
        }

        public TransactionDefinition getTransactionDefinition() {
            return this.transactionDefinition;
        }

        @NonNull
        public Object getTransaction() {
            return this.springStatus;
        }

        @NonNull
        public Connection getConnection() {
            return (Connection)AbstractSpringTransactionOperations.this.getConnection();
        }

        public ConnectionStatus<Connection> getConnectionStatus() {
            throw new IllegalStateException("Connections status not supported for the Spring TX manager!");
        }

        public void registerSynchronization(final @NonNull io.micronaut.transaction.support.TransactionSynchronization synchronization) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public int getOrder() {
                    return synchronization.getOrder();
                }

                public void beforeCommit(boolean readOnly) {
                    synchronization.beforeCommit(readOnly);
                }

                public void beforeCompletion() {
                    synchronization.beforeCompletion();
                }

                public void afterCommit() {
                    synchronization.afterCommit();
                }

                public void afterCompletion(int status) {
                    switch (status) {
                        case 0: {
                            synchronization.afterCompletion(TransactionSynchronization.Status.COMMITTED);
                            break;
                        }
                        case 1: {
                            synchronization.afterCompletion(TransactionSynchronization.Status.ROLLED_BACK);
                            break;
                        }
                        case 2: {
                            synchronization.afterCompletion(TransactionSynchronization.Status.UNKNOWN);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown status: " + status);
                        }
                    }
                }
            });
        }
    }
}

