/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.query.internal;

import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.DataAnnotationUtils;
import io.micronaut.data.annotation.ParameterExpression;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.annotation.QueryHint;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.intercept.annotation.DataMethodQuery;
import io.micronaut.data.intercept.annotation.DataMethodQueryParameter;
import io.micronaut.data.model.AssociationUtils;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Limit;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.DefaultStoredDataOperation;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.operations.HintsCapableRepository;
import io.micronaut.inject.ExecutableMethod;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;

@Internal
public final class DefaultStoredQuery<E, RT>
extends DefaultStoredDataOperation<RT>
implements StoredQuery<E, RT> {
    private static final String DATA_METHOD_ANN_NAME = DataMethod.class.getName();
    private final @NonNull Class<RT> resultType;
    private final DataType resultDataType;
    private final @NonNull Class<E> rootEntity;
    private final @NonNull String query;
    private final String[] queryParts;
    private final ExecutableMethod<?, ?> method;
    private final boolean isDto;
    private final boolean isOptimisticLock;
    private final boolean isNative;
    private final boolean isProcedure;
    private final boolean hasPageable;
    private final AnnotationMetadata annotationMetadata;
    private final boolean isCount;
    private final boolean hasResultConsumer;
    private Map<String, Object> queryHints;
    private Set<JoinPath> joinPaths = null;
    private Set<JoinPath> joinFetchPaths = null;
    private final List<QueryParameterBinding> queryParameters;
    private final boolean rawQuery;
    private final boolean jsonEntity;
    private final StoredQuery.OperationType operationType;
    private final Map<String, AnnotationValue<?>> parameterExpressions;
    private final Limit limit;
    private final Sort sort;
    private final Function<Object, Object> stringsEnvResolverValueMapper;

    public DefaultStoredQuery(@NonNull ExecutableMethod<?, ?> method, boolean isCount, HintsCapableRepository repositoryOperations) {
        this(method, (AnnotationValue<Annotation>)method.getAnnotation(DataMethod.NAME), isCount, repositoryOperations);
    }

    public DefaultStoredQuery(@NonNull ExecutableMethod<?, ?> method, AnnotationValue<Annotation> dataMethodQuery, HintsCapableRepository repositoryOperations) {
        this(method, dataMethodQuery, false, repositoryOperations);
    }

    public DefaultStoredQuery(@NonNull ExecutableMethod<?, ?> method, AnnotationValue<Annotation> dataMethodQuery, boolean isCount, HintsCapableRepository repositoryOperations) {
        super(method);
        Map queryHints;
        if (repositoryOperations instanceof ApplicationContextProvider) {
            ApplicationContextProvider applicationContextProvider = (ApplicationContextProvider)repositoryOperations;
            Environment environment = applicationContextProvider.getApplicationContext().getEnvironment();
            this.stringsEnvResolverValueMapper = DefaultStoredQuery.createEnvResolverValueMapper(environment);
        } else {
            this.stringsEnvResolverValueMapper = null;
        }
        this.rootEntity = DefaultStoredQuery.getRequiredRootEntity(method);
        this.annotationMetadata = method.getAnnotationMetadata();
        this.isProcedure = dataMethodQuery.isTrue("procedure");
        this.hasResultConsumer = method.stringValue(DATA_METHOD_ANN_NAME, "sqlMappingFunction").isPresent();
        boolean isNumericPlaceHolder = method.classValue(RepositoryConfiguration.class, "queryBuilder").map(c -> c == SqlQueryBuilder.class).orElse(false);
        boolean bl = this.hasPageable = dataMethodQuery.stringValue("pageable").isPresent() || dataMethodQuery.stringValue("sort").isPresent() || dataMethodQuery.intValue("limit").orElse(-1) > -1 || dataMethodQuery.intValue("pageSize").orElse(-1) > -1;
        if (isCount) {
            AnnotationValue queryAnnotation = method.getAnnotation(Query.class.getName());
            query = queryAnnotation.stringValue("countQuery").orElseGet(() -> (String)queryAnnotation.stringValue().orElseThrow(() -> new IllegalStateException("No query present in method")));
            Optional rawCountQueryString = method.stringValue(Query.class, "rawCountQuery");
            this.rawQuery = rawCountQueryString.isPresent();
            this.query = rawCountQueryString.orElse(query);
            Object[] countQueryParts = method.stringValues(DataMethod.class, "expandableCountQuery");
            this.queryParts = ArrayUtils.isNotEmpty((Object[])countQueryParts) ? countQueryParts : method.stringValues(DataMethodQuery.class, "expandableQuery");
            this.isNative = queryAnnotation.isTrue("nativeQuery");
            this.resultType = Long.class;
            this.resultDataType = DataType.LONG;
        } else {
            Optional q = dataMethodQuery.stringValue();
            if (q.isPresent()) {
                Optional rawQueryString = dataMethodQuery.stringValue("rawQuery");
                this.isNative = dataMethodQuery.isTrue("nativeQuery");
                this.rawQuery = rawQueryString.isPresent();
                this.query = rawQueryString.orElseGet(q::get);
            } else {
                AnnotationValue queryAnnotation = method.getAnnotation(Query.class.getName());
                query = (String)queryAnnotation.stringValue().orElseThrow(() -> new IllegalStateException("No query present in method"));
                Optional rawQueryString = queryAnnotation.stringValue("rawQuery");
                this.isNative = queryAnnotation.isTrue("nativeQuery");
                this.rawQuery = rawQueryString.isPresent();
                this.query = rawQueryString.orElse(query);
            }
            this.resultDataType = dataMethodQuery.enumValue("resultDataType", DataType.class).orElse(DataType.OBJECT);
            this.queryParts = this.getQueryParts(dataMethodQuery, "expandableQuery");
            this.resultType = dataMethodQuery.classValue("resultType").map(type -> ReflectionUtils.getWrapperType((Class)type)).orElse(this.rootEntity);
        }
        this.method = method;
        this.isDto = dataMethodQuery.isTrue("dto");
        this.isOptimisticLock = dataMethodQuery.isTrue("optimisticLock");
        this.operationType = dataMethodQuery.enumValue("opType", DataMethodQuery.OperationType.class).map(op -> StoredQuery.OperationType.valueOf((String)op.name())).orElse(StoredQuery.OperationType.QUERY);
        boolean bl2 = this.isCount = isCount || this.operationType == StoredQuery.OperationType.COUNT;
        if (method.hasAnnotation(QueryHint.class)) {
            List values = method.getAnnotationValuesByType(QueryHint.class);
            this.queryHints = new HashMap<String, Object>(values.size());
            for (AnnotationValue value : values) {
                String n = value.stringValue("name").orElse(null);
                String v = value.stringValue("value").orElse(null);
                if (!StringUtils.isNotEmpty((CharSequence)n) || !StringUtils.isNotEmpty((CharSequence)v)) continue;
                this.queryHints.put(n, v);
            }
        }
        if ((queryHints = repositoryOperations.getQueryHints((StoredQuery)this)) != Collections.EMPTY_MAP) {
            if (this.queryHints != null) {
                this.queryHints.putAll(queryHints);
            } else {
                this.queryHints = queryHints;
            }
        }
        this.queryParameters = DefaultStoredQuery.getQueryParameters(dataMethodQuery.getAnnotations("parameters", DataMethodQueryParameter.class), isNumericPlaceHolder);
        this.jsonEntity = DataAnnotationUtils.hasJsonEntityRepresentationAnnotation((AnnotationMetadata)this.annotationMetadata);
        this.parameterExpressions = this.annotationMetadata.getAnnotationValuesByType(ParameterExpression.class).stream().collect(Collectors.toMap(av -> (String)av.stringValue("name").orElseThrow(), av -> av));
        this.limit = Limit.of((int)dataMethodQuery.intValue("limit").orElse(-1), (long)dataMethodQuery.intValue("offset").orElse(0));
        this.sort = Sort.of(dataMethodQuery.getAnnotations("sorts").stream().map(av -> new Sort.Order((String)av.stringValue().orElseThrow(), av.enumValue("direction", Sort.Order.Direction.class).orElse(Sort.Order.Direction.ASC), av.booleanValue("ignoreCase").orElse(false).booleanValue())).toList());
    }

    private static <E> Class<E> getRequiredRootEntity(ExecutableMethod<?, ?> context) {
        Class aClass = context.classValue(DataMethod.NAME, "rootEntity").orElse(null);
        if (aClass != null) {
            return aClass;
        }
        AnnotationValue ann = context.getDeclaredAnnotation(DataMethod.NAME);
        if (ann != null && (aClass = (Class)ann.classValue("rootEntity").orElse(null)) != null) {
            return aClass;
        }
        throw new IllegalStateException("No root entity present in method");
    }

    /*
     * Exception decompiling
     */
    private static List<QueryParameterBinding> getQueryParameters(List<AnnotationValue<DataMethodQueryParameter>> params, boolean isNumericPlaceHolder) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Limit getQueryLimit() {
        return this.limit;
    }

    public Sort getSort() {
        return this.sort;
    }

    public List<QueryParameterBinding> getQueryBindings() {
        return this.queryParameters;
    }

    public Set<JoinPath> getJoinPaths() {
        if (this.joinPaths == null) {
            this.joinPaths = Collections.unmodifiableSet(AssociationUtils.getJoinPaths(this.method));
        }
        return this.joinPaths;
    }

    public ExecutableMethod<?, ?> getMethod() {
        return this.method;
    }

    public boolean hasResultConsumer() {
        return this.hasResultConsumer;
    }

    public boolean isCount() {
        return this.isCount;
    }

    public @NonNull Map<String, Object> getQueryHints() {
        if (this.queryHints != null) {
            return this.queryHints;
        }
        return Collections.emptyMap();
    }

    public boolean isNative() {
        return this.isNative;
    }

    public boolean isProcedure() {
        return this.isProcedure;
    }

    public StoredQuery.OperationType getOperationType() {
        return this.operationType;
    }

    public boolean isDtoProjection() {
        return this.isDto;
    }

    public @NonNull Class<RT> getResultType() {
        return this.resultType;
    }

    public @NonNull DataType getResultDataType() {
        return this.resultDataType;
    }

    public @NonNull Class<E> getRootEntity() {
        return this.rootEntity;
    }

    public boolean hasPageable() {
        return this.hasPageable;
    }

    public @NonNull String getQuery() {
        return this.query;
    }

    public String[] getExpandableQueryParts() {
        return this.queryParts;
    }

    public @NonNull String getName() {
        return this.method.getMethodName();
    }

    public boolean isOptimisticLock() {
        return this.isOptimisticLock;
    }

    public boolean isRawQuery() {
        return this.rawQuery;
    }

    public boolean isJsonEntity() {
        return this.jsonEntity;
    }

    public Map<String, AnnotationValue<?>> getParameterExpressions() {
        return this.parameterExpressions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DefaultStoredQuery that = (DefaultStoredQuery)((Object)o);
        return this.resultType.equals(that.resultType) && this.method.equals(that.method);
    }

    public int hashCode() {
        return Objects.hash(this.resultType, this.method);
    }

    private String[] getQueryParts(@NonNull AnnotationValue annotationValue, @NonNull String member) {
        if (this.stringsEnvResolverValueMapper != null) {
            return annotationValue.stringValues(member, this.stringsEnvResolverValueMapper);
        }
        return annotationValue.stringValues(member);
    }

    private static Function<Object, Object> createEnvResolverValueMapper(Environment environment) {
        return o -> {
            PropertyPlaceholderResolver resolver = environment.getPlaceholderResolver();
            if (o instanceof String[]) {
                String[] values = (String[])o;
                String[] resolvedValues = Arrays.copyOf(values, values.length);
                for (int i = 0; i < values.length; ++i) {
                    String value = values[i];
                    if (value.contains(resolver.getPrefix())) {
                        value = resolver.resolveRequiredPlaceholders(value);
                    }
                    resolvedValues[i] = value;
                }
                return resolvedValues;
            }
            return o;
        };
    }
}

