/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations;

import io.micronaut.core.async.propagation.ReactorPropagation;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.async.AsyncRepositoryOperations;
import io.micronaut.data.operations.reactive.ReactorReactiveRepositoryOperations;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.jspecify.annotations.NonNull;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public final class ReactorToAsyncOperationsAdaptor
implements AsyncRepositoryOperations {
    private final ReactorReactiveRepositoryOperations reactiveOperations;
    private final Executor executor;

    public ReactorToAsyncOperationsAdaptor(ReactorReactiveRepositoryOperations reactiveOperations, Executor executor) {
        this.reactiveOperations = reactiveOperations;
        this.executor = executor;
    }

    public @NonNull Executor getExecutor() {
        return this.executor;
    }

    public <T> @NonNull CompletionStage<T> findOne(@NonNull Class<T> type, @NonNull Object id) {
        return this.toCompletionStage(this.reactiveOperations.findOne(type, id));
    }

    public <T> CompletionStage<Boolean> exists(@NonNull PreparedQuery<T, Boolean> preparedQuery) {
        return this.toCompletionStage(this.reactiveOperations.exists(preparedQuery));
    }

    public <T, R> @NonNull CompletionStage<R> findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
        return this.toCompletionStage(this.reactiveOperations.findOne(preparedQuery));
    }

    public <T> @NonNull CompletionStage<T> findOptional(@NonNull Class<T> type, @NonNull Object id) {
        return this.toCompletionStage(this.reactiveOperations.findOptional(type, id));
    }

    public <T, R> @NonNull CompletionStage<R> findOptional(@NonNull PreparedQuery<T, R> preparedQuery) {
        return this.toCompletionStage(this.reactiveOperations.findOptional(preparedQuery));
    }

    public <T> @NonNull CompletionStage<Iterable<T>> findAll(PagedQuery<T> pagedQuery) {
        return this.toCompletionStage(this.reactiveOperations.findAll(pagedQuery));
    }

    public <T> @NonNull CompletionStage<Long> count(PagedQuery<T> pagedQuery) {
        return this.toCompletionStage(this.reactiveOperations.count(pagedQuery));
    }

    public <T, R> @NonNull CompletionStage<Iterable<R>> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
        return this.toCompletionStage(this.reactiveOperations.findAll(preparedQuery));
    }

    public <T> @NonNull CompletionStage<T> persist(@NonNull InsertOperation<T> operation) {
        return this.toCompletionStage(this.reactiveOperations.persist(operation));
    }

    public <T> @NonNull CompletionStage<T> update(@NonNull UpdateOperation<T> operation) {
        return this.toCompletionStage(this.reactiveOperations.update(operation));
    }

    public <T> @NonNull CompletionStage<Number> delete(@NonNull DeleteOperation<T> operation) {
        return this.toCompletionStage(this.reactiveOperations.delete(operation));
    }

    public <T> @NonNull CompletionStage<Iterable<T>> persistAll(@NonNull InsertBatchOperation<T> operation) {
        return this.toCompletionStage(this.reactiveOperations.persistAll(operation));
    }

    public @NonNull CompletionStage<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return this.toCompletionStage(this.reactiveOperations.executeUpdate(preparedQuery));
    }

    public CompletionStage<Number> executeDelete(PreparedQuery<?, Number> preparedQuery) {
        return this.toCompletionStage(this.reactiveOperations.executeDelete(preparedQuery));
    }

    public <R> CompletionStage<List<R>> execute(PreparedQuery<?, R> preparedQuery) {
        return this.toCompletionStage(this.reactiveOperations.execute(preparedQuery).collectList());
    }

    public <T> @NonNull CompletionStage<Number> deleteAll(@NonNull DeleteBatchOperation<T> operation) {
        return this.toCompletionStage(this.reactiveOperations.deleteAll(operation));
    }

    public <R> @NonNull CompletionStage<Page<R>> findPage(@NonNull PagedQuery<R> pagedQuery) {
        return this.toCompletionStage(this.reactiveOperations.findPage(pagedQuery));
    }

    public <T> @NonNull CompletionStage<Iterable<T>> updateAll(@NonNull UpdateBatchOperation<T> operation) {
        return this.toCompletionStage(this.reactiveOperations.updateAll(operation));
    }

    private <T> CompletionStage<Iterable<T>> toCompletionStage(Flux<T> flux) {
        return flux.contextWrite(ctx -> ReactorPropagation.addPropagatedContext((Context)ctx, (PropagatedContext)PropagatedContext.getOrEmpty())).collectList().map(list -> list).toFuture();
    }

    private <T> CompletionStage<T> toCompletionStage(Mono<T> mono) {
        return mono.contextWrite(ctx -> ReactorPropagation.addPropagatedContext((Context)ctx, (PropagatedContext)PropagatedContext.getOrEmpty())).toFuture();
    }
}

