/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncRepositoryOperations;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;

public class ExecutorAsyncOperations
implements AsyncRepositoryOperations {
    private final RepositoryOperations datastore;
    private final Executor executor;

    public ExecutorAsyncOperations(@NonNull RepositoryOperations operations, @NonNull Executor executor) {
        ArgumentUtils.requireNonNull((String)"operations", (Object)operations);
        ArgumentUtils.requireNonNull((String)"executor", (Object)executor);
        this.datastore = operations;
        this.executor = executor;
    }

    @Internal
    final <T> CompletableFuture<T> supplyAsync(Supplier<T> supplier) {
        CompletableFuture cf = new CompletableFuture();
        PropagatedContext propagatedContext = PropagatedContext.getOrEmpty();
        CompletableFuture.supplyAsync(PropagatedContext.wrapCurrent(supplier), this.executor).whenComplete((value, throwable) -> propagatedContext.propagate(() -> {
            if (throwable != null) {
                cf.completeExceptionally((Throwable)throwable);
            } else {
                cf.complete(value);
            }
            return null;
        }));
        return cf;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public <T> @NonNull CompletableFuture<T> findOne(@NonNull Class<T> type, @NonNull Object id) {
        return this.supplyAsync(() -> this.datastore.findOne(type, id));
    }

    public <T> CompletableFuture<Boolean> exists(@NonNull PreparedQuery<T, Boolean> preparedQuery) {
        return this.supplyAsync(() -> this.datastore.exists(preparedQuery));
    }

    public <T, R> @NonNull CompletableFuture<R> findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
        return this.supplyAsync(() -> this.datastore.findOne(preparedQuery));
    }

    public <T> @NonNull CompletableFuture<T> findOptional(@NonNull Class<T> type, @NonNull Object id) {
        return this.supplyAsync(() -> this.datastore.findOne(type, id));
    }

    public <T, R> @NonNull CompletableFuture<R> findOptional(@NonNull PreparedQuery<T, R> preparedQuery) {
        return this.supplyAsync(() -> this.datastore.findOne(preparedQuery));
    }

    public <T> @NonNull CompletableFuture<Iterable<T>> findAll(@NonNull PagedQuery<T> pagedQuery) {
        return this.supplyAsync(() -> this.datastore.findAll(pagedQuery));
    }

    public <T> CompletableFuture<Long> count(@NonNull PagedQuery<T> pagedQuery) {
        return this.supplyAsync(() -> this.datastore.count(pagedQuery));
    }

    public <T, R> @NonNull CompletableFuture<Iterable<R>> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
        return this.supplyAsync(() -> this.datastore.findAll(preparedQuery));
    }

    public <T> @NonNull CompletableFuture<T> persist(@NonNull InsertOperation<T> entity) {
        return this.supplyAsync(() -> this.datastore.persist(entity));
    }

    public <T> @NonNull CompletableFuture<T> update(@NonNull UpdateOperation<T> operation) {
        return this.supplyAsync(() -> this.datastore.update(operation));
    }

    public <T> @NonNull CompletableFuture<Iterable<T>> updateAll(@NonNull UpdateBatchOperation<T> operation) {
        return this.supplyAsync(() -> this.datastore.updateAll(operation));
    }

    public <T> @NonNull CompletableFuture<Number> delete(@NonNull DeleteOperation<T> operation) {
        return this.supplyAsync(() -> this.datastore.delete(operation));
    }

    public <T> @NonNull CompletableFuture<Iterable<T>> persistAll(@NonNull InsertBatchOperation<T> operation) {
        return this.supplyAsync(() -> this.datastore.persistAll(operation));
    }

    public @NonNull CompletableFuture<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return this.supplyAsync(() -> this.datastore.executeUpdate(preparedQuery).orElse(0));
    }

    public CompletionStage<Number> executeDelete(PreparedQuery<?, Number> preparedQuery) {
        return this.supplyAsync(() -> this.datastore.executeDelete(preparedQuery).orElse(0));
    }

    public <T> @NonNull CompletableFuture<Number> deleteAll(@NonNull DeleteBatchOperation<T> operation) {
        return this.supplyAsync(() -> this.datastore.deleteAll(operation).orElse(0));
    }

    public <R> CompletableFuture<Page<R>> findPage(@NonNull PagedQuery<R> pagedQuery) {
        return this.supplyAsync(() -> this.datastore.findPage(pagedQuery));
    }
}

