/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.mapper.sql;

import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.data.runtime.mapper.sql.SqlJsonColumnReader;
import io.micronaut.data.runtime.mapper.sql.SqlTypeMapper;
import java.util.function.BiFunction;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class JsonQueryResultMapper<T, RS, R>
implements SqlTypeMapper<RS, R> {
    private final String columnName;
    private final JsonDataType jsonDataType;
    private final RuntimePersistentEntity<T> entity;
    private final ResultReader<RS, String> resultReader;
    private final SqlJsonColumnReader<RS> sqlJsonColumnReader;
    private final BiFunction<RuntimePersistentEntity<Object>, Object, Object> eventListener;

    public JsonQueryResultMapper(@NonNull String columnName, @NonNull JsonDataType jsonDataType, @NonNull RuntimePersistentEntity<T> entity, @NonNull ResultReader<RS, String> resultReader, @NonNull SqlJsonColumnReader<RS> sqlJsonColumnReader, @Nullable BiFunction<RuntimePersistentEntity<Object>, Object, Object> eventListener) {
        ArgumentUtils.requireNonNull((String)"columnName", (Object)columnName);
        ArgumentUtils.requireNonNull((String)"jsonDataType", (Object)jsonDataType);
        ArgumentUtils.requireNonNull((String)"sqlJsonColumnReader", sqlJsonColumnReader);
        this.columnName = columnName;
        this.jsonDataType = jsonDataType;
        this.entity = entity;
        this.resultReader = resultReader;
        this.sqlJsonColumnReader = sqlJsonColumnReader;
        this.eventListener = eventListener;
    }

    @Override
    public R map(RS rs, Class<R> type) throws DataAccessException {
        Object entityInstance = this.sqlJsonColumnReader.readJsonColumn(this.resultReader, rs, this.columnName, this.jsonDataType, Argument.of(type));
        if (entityInstance == null) {
            throw new DataAccessException("Unable to map result to entity of type [" + type.getName() + "]. Missing result data.");
        }
        return (R)this.triggerPostLoad(this.entity, entityInstance);
    }

    @Override
    public Object read(RS object, String name) {
        throw new UnsupportedOperationException("Custom field read is not supported");
    }

    @Override
    public boolean hasNext(RS resultSet) {
        return this.resultReader.next(resultSet);
    }

    private <K> K triggerPostLoad(RuntimePersistentEntity<?> persistentEntity, K entity) {
        Object finalEntity = this.eventListener != null && persistentEntity.hasPostLoadEventListeners() ? this.eventListener.apply(persistentEntity, entity) : entity;
        return finalEntity;
    }
}

