/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.reactive;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.reactive.FindPageReactiveInterceptor;
import io.micronaut.data.model.CursoredPage;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.reactive.AbstractPublisherInterceptor;
import io.micronaut.data.runtime.operations.internal.sql.DefaultSqlPreparedQuery;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class DefaultFindPageReactiveInterceptor
extends AbstractPublisherInterceptor
implements FindPageReactiveInterceptor<Object, Object> {
    protected DefaultFindPageReactiveInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
    }

    @Override
    public Publisher<?> interceptPublisher(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        if (context.hasAnnotation(Query.class)) {
            PreparedQuery preparedQuery = this.prepareQuery(methodKey, context);
            PreparedQuery<?, Number> countQuery = this.prepareCountQuery(methodKey, context);
            return Flux.from((Publisher)this.reactiveOperations.findOne(countQuery)).flatMap(total -> {
                Flux resultList = Flux.from((Publisher)this.reactiveOperations.findAll(preparedQuery));
                return resultList.collectList().map(list -> {
                    Page page;
                    Pageable pageable = preparedQuery.getPageable();
                    if (pageable.getMode() == Pageable.Mode.OFFSET) {
                        page = Page.of((List)list, (Pageable)pageable, (Long)total.longValue());
                    } else if (preparedQuery instanceof DefaultSqlPreparedQuery) {
                        List<Pageable.Cursor> cursors;
                        DefaultSqlPreparedQuery sqlPreparedQuery = (DefaultSqlPreparedQuery)preparedQuery;
                        if (preparedQuery.getResultDataType() == DataType.ENTITY) {
                            cursors = sqlPreparedQuery.createCursors((List<Object>)list, pageable);
                        } else if (sqlPreparedQuery.isDtoProjection()) {
                            RuntimePersistentEntity runtimePersistentEntity = this.operations.getEntity(sqlPreparedQuery.getResultType());
                            cursors = sqlPreparedQuery.createCursors((List<Object>)list, pageable, (RuntimePersistentEntity<Object>)runtimePersistentEntity);
                        } else {
                            throw new IllegalStateException("CursoredPage cannot produce projection result");
                        }
                        page = CursoredPage.of((List)list, (Pageable)pageable, cursors, (Long)total.longValue());
                    } else {
                        throw new UnsupportedOperationException("Only offset pageable mode is supported by this query implementation");
                    }
                    return page;
                });
            });
        }
        return this.reactiveOperations.findPage(this.getPagedQuery(context));
    }
}

