/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria.async;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncCapableRepository;
import io.micronaut.data.operations.async.AsyncCriteriaCapableRepository;
import io.micronaut.data.operations.async.AsyncCriteriaRepositoryOperations;
import io.micronaut.data.operations.async.AsyncRepositoryOperations;
import io.micronaut.data.runtime.intercept.criteria.AbstractSpecificationInterceptor;
import io.micronaut.data.runtime.intercept.criteria.async.PreparedQueryAsyncCriteriaRepositoryOperations;
import jakarta.persistence.criteria.CriteriaQuery;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
public abstract class AbstractAsyncSpecificationInterceptor<T, R>
extends AbstractSpecificationInterceptor<T, R> {
    protected static final Argument<List<Object>> LIST_OF_OBJECTS = Argument.listOf(Object.class);
    protected final AsyncRepositoryOperations asyncOperations;
    protected final AsyncCriteriaRepositoryOperations asyncCriteriaOperations;

    protected AbstractAsyncSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
        if (!(operations instanceof AsyncCapableRepository)) {
            throw new DataAccessException("Datastore of type [" + String.valueOf(operations.getClass()) + "] does not support asynchronous operations");
        }
        AsyncCapableRepository asyncCapableRepository = (AsyncCapableRepository)operations;
        this.asyncOperations = asyncCapableRepository.async();
        if (operations instanceof AsyncCriteriaRepositoryOperations) {
            AsyncCriteriaRepositoryOperations asyncCriteriaRepositoryOperations;
            this.asyncCriteriaOperations = asyncCriteriaRepositoryOperations = (AsyncCriteriaRepositoryOperations)operations;
        } else {
            AsyncRepositoryOperations asyncRepositoryOperations = this.asyncOperations;
            if (asyncRepositoryOperations instanceof AsyncCriteriaRepositoryOperations) {
                AsyncCriteriaRepositoryOperations asyncCriteriaRepositoryOperations;
                this.asyncCriteriaOperations = asyncCriteriaRepositoryOperations = (AsyncCriteriaRepositoryOperations)asyncRepositoryOperations;
            } else if (operations instanceof AsyncCriteriaCapableRepository) {
                AsyncCriteriaCapableRepository repository = (AsyncCriteriaCapableRepository)operations;
                this.asyncCriteriaOperations = repository.async();
            } else {
                this.asyncCriteriaOperations = null;
            }
        }
        if (this.asyncCriteriaOperations != null) {
            this.criteriaBuilder = this.asyncCriteriaOperations.getCriteriaBuilder();
        }
    }

    final AsyncCriteriaRepositoryOperations getAsyncCriteriaRepositoryOperations(RepositoryMethodKey methodKey, MethodInvocationContext<?, ?> context, Pageable pageable) {
        if (this.asyncCriteriaOperations != null) {
            return this.asyncCriteriaOperations;
        }
        QueryBuilder sqlQueryBuilder = this.getQueryBuilder(methodKey, context);
        return new PreparedQueryAsyncCriteriaRepositoryOperations(this.criteriaBuilder, this.asyncOperations, this.operations, context, sqlQueryBuilder, this.getRequiredRootEntity(context), pageable);
    }

    protected final @NonNull CompletionStage<Iterable<Object>> findAllAsync(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context) {
        CriteriaQuery<Object> criteriaQuery = this.buildQuery(methodKey, context);
        Pageable pageable = this.applyPaginationAndSort(this.getPageable(context), criteriaQuery, true);
        if (this.asyncCriteriaOperations != null) {
            if (pageable != null && !pageable.isUnpaged()) {
                return this.asyncCriteriaOperations.findAll(criteriaQuery, (int)pageable.getOffset(), pageable.getSize()).thenApply(m -> m);
            }
            return this.asyncCriteriaOperations.findAll(criteriaQuery).thenApply(m -> m);
        }
        return this.getAsyncCriteriaRepositoryOperations(methodKey, context, pageable).findAll(criteriaQuery).thenApply(m -> m);
    }

    @Override
    protected final Argument<?> getReturnType(MethodInvocationContext<?, ?> context) {
        return this.findReturnType(context, Argument.OBJECT_ARGUMENT);
    }

    protected final Argument<?> findReturnType(MethodInvocationContext<?, ?> context, Argument<?> defaultArg) {
        if (context.isSuspend()) {
            return context.getReturnType().asArgument();
        }
        return context.getReturnType().asArgument().getFirstTypeVariable().orElse(defaultArg);
    }

    protected @Nullable Number convertNumberToReturnType(MethodInvocationContext<?, ?> context, Number number) {
        Argument<?> firstTypeVar = this.findReturnType(context, Argument.LONG);
        Class type = firstTypeVar.getType();
        if (type == Object.class || type == Void.class) {
            return null;
        }
        if (number == null) {
            number = 0;
        }
        if (!type.isInstance(number)) {
            return (Number)this.operations.getConversionService().convert((Object)number, firstTypeVar).orElseThrow(() -> new IllegalStateException("Unsupported number type for return type: " + String.valueOf(firstTypeVar)));
        }
        return number;
    }
}

