/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.CursoredPage;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.criteria.AbstractSpecificationInterceptor;
import io.micronaut.data.runtime.operations.internal.sql.DefaultSqlPreparedQuery;
import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;

@Internal
public class FindPageSpecificationInterceptor
extends AbstractSpecificationInterceptor<Object, Object> {
    protected FindPageSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        Page page;
        List<Object> iterable;
        Pageable pageable = this.getPageable(context);
        CriteriaQuery<Object> criteriaQuery = this.buildQuery(methodKey, context);
        Root root = (Root)criteriaQuery.getRoots().iterator().next();
        if (root.getJoins().isEmpty() && root.getFetches().isEmpty()) {
            iterable = this.findAll(methodKey, context, pageable, criteriaQuery);
        } else {
            CriteriaQuery<Tuple> criteriaIdsQuery = this.buildIdsQuery(methodKey, context, (Sort)pageable);
            List<Tuple> tupleResult = this.findAll(methodKey, context, pageable, criteriaIdsQuery);
            if (tupleResult.isEmpty()) {
                iterable = List.of();
            } else {
                ArrayList<Object> ids = new ArrayList<Object>(tupleResult.size());
                for (Tuple tuple : tupleResult) {
                    ids.add(tuple.get(0));
                }
                Predicate inPredicate = this.getIdExpression(root).in(ids);
                criteriaQuery.where((Expression)inPredicate);
                iterable = this.findAll(methodKey, context, pageable.withoutPaging(), criteriaQuery);
            }
        }
        List resultList = CollectionUtils.iterableToList(iterable);
        Long count = null;
        if (pageable.requestTotal()) {
            CriteriaQuery<Long> query = this.buildCountQuery(methodKey, context);
            count = (Long)this.getCriteriaRepositoryOperations(methodKey, context, null).findOne(query);
        }
        if (pageable.getMode() == Pageable.Mode.OFFSET) {
            page = Page.of((List)resultList, (Pageable)pageable, count);
        } else {
            PreparedQuery preparedQuery = context.getAttribute((CharSequence)"PREPARED_QUERY").orElse(null);
            if (preparedQuery instanceof DefaultSqlPreparedQuery) {
                DefaultSqlPreparedQuery sqlPreparedQuery = (DefaultSqlPreparedQuery)preparedQuery;
                List<Pageable.Cursor> cursors = sqlPreparedQuery.createCursors(resultList, pageable);
                page = CursoredPage.of((List)resultList, (Pageable)pageable, cursors, (Long)count);
            } else {
                throw new UnsupportedOperationException("Only offset pageable mode is supported by this query implementation");
            }
        }
        Class rt = context.getReturnType().getType();
        if (rt.isInstance(page)) {
            return page;
        }
        return this.operations.getConversionService().convert((Object)page, rt).orElseThrow(() -> new IllegalStateException("Unsupported page interface type " + String.valueOf(rt)));
    }
}

