/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.async;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.async.DeleteAllAsyncInterceptor;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.async.AbstractCountConvertCompletionStageInterceptor;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.jspecify.annotations.NonNull;

public class DefaultDeleteAllAsyncInterceptor<T>
extends AbstractCountConvertCompletionStageInterceptor
implements DeleteAllAsyncInterceptor<Object, Object> {
    protected DefaultDeleteAllAsyncInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    @Override
    protected CompletionStage<?> interceptCompletionStage(RepositoryMethodKey methodKey, MethodInvocationContext<Object, CompletionStage<Object>> context) {
        Optional<Iterable<Object>> deleteEntities = this.findEntitiesParameter(context, Object.class);
        Optional<Object> deleteEntity = this.findEntityParameter(context, Object.class);
        if (deleteEntity.isEmpty() && deleteEntities.isEmpty()) {
            PreparedQuery preparedQuery = this.prepareQuery(methodKey, context);
            return this.asyncDatastoreOperations.executeDelete(preparedQuery);
        }
        if (deleteEntity.isPresent()) {
            return this.asyncDatastoreOperations.delete(this.getDeleteOperation(context, deleteEntity.get()));
        }
        return this.asyncDatastoreOperations.deleteAll(this.getDeleteBatchOperation(context, deleteEntities.get()));
    }
}

