/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.async;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncCapableRepository;
import io.micronaut.data.operations.async.AsyncRepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import io.micronaut.data.runtime.intercept.async.DefaultProcedureReturningManyAsyncInterceptor;
import java.util.concurrent.CompletionStage;
import org.jspecify.annotations.NonNull;

@Internal
abstract sealed class AbstractAsyncInterceptor2<T, R>
extends AbstractQueryInterceptor<T, CompletionStage<? extends R>>
permits DefaultProcedureReturningManyAsyncInterceptor {
    protected final @NonNull AsyncRepositoryOperations asyncDatastoreOperations;

    protected AbstractAsyncInterceptor2(@NonNull RepositoryOperations datastore) {
        super(datastore);
        if (!(datastore instanceof AsyncCapableRepository)) {
            throw new DataAccessException("Datastore of type [" + String.valueOf(datastore.getClass()) + "] does not support asynchronous operations");
        }
        AsyncCapableRepository asyncCapableRepository = (AsyncCapableRepository)datastore;
        this.asyncDatastoreOperations = asyncCapableRepository.async();
    }

    @Override
    protected final Argument<?> getReturnType(MethodInvocationContext<?, ?> context) {
        return this.findReturnType(context, Argument.OBJECT_ARGUMENT);
    }

    protected final Argument<?> findReturnType(MethodInvocationContext<?, ?> context, Argument<?> defaultArg) {
        if (context.isSuspend()) {
            return context.getReturnType().asArgument();
        }
        return context.getReturnType().asArgument().getFirstTypeVariable().orElse(defaultArg);
    }
}

