/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.criteria;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.jpa.criteria.PersistentAssociationPath;
import io.micronaut.data.model.jpa.criteria.PersistentEntityFrom;
import io.micronaut.data.model.jpa.criteria.PersistentEntityPath;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.runtime.criteria.AbstractRuntimePersistentEntityFrom;
import io.micronaut.data.runtime.criteria.RuntimePersistentCollectionAssociationPath;
import io.micronaut.data.runtime.criteria.RuntimePersistentListAssociationPath;
import io.micronaut.data.runtime.criteria.RuntimePersistentSetAssociationPath;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Fetch;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.metamodel.Attribute;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;

@Internal
sealed class RuntimePersistentAssociationPath<Owner, E>
extends AbstractRuntimePersistentEntityFrom<Owner, E>
implements PersistentEntityPath<E>,
PersistentAssociationPath<Owner, E>,
Fetch<Owner, E>
permits RuntimePersistentCollectionAssociationPath, RuntimePersistentListAssociationPath, RuntimePersistentSetAssociationPath {
    private final PersistentEntityFrom<?, Owner> parent;
    private final RuntimeAssociation<Owner> association;
    private final List<Association> associations;
    private Join.Type associationJoinType;
    private @Nullable String alias;

    RuntimePersistentAssociationPath(PersistentEntityFrom<?, Owner> parent, RuntimeAssociation<Owner> association, List<Association> associations, Join.Type associationJoinType, @Nullable String alias, CriteriaBuilder criteriaBuilder) {
        super(criteriaBuilder);
        this.parent = parent;
        this.association = association;
        this.associations = associations;
        this.associationJoinType = associationJoinType;
        this.alias = alias;
    }

    public PersistentEntityFrom<?, Owner> getParent() {
        return this.parent;
    }

    public Join.Type getAssociationJoinType() {
        return this.associationJoinType;
    }

    public void setAssociationJoinType(Join.Type type) {
        this.associationJoinType = type;
    }

    public @Nullable String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Path<?> getParentPath() {
        return this.parent;
    }

    public RuntimeAssociation<Owner> getProperty() {
        return this.association;
    }

    public Association getAssociation() {
        return this.association;
    }

    public List<Association> getAssociations() {
        return this.associations;
    }

    @Override
    public RuntimePersistentEntity<E> getPersistentEntity() {
        return this.association.getAssociatedEntity();
    }

    @Override
    protected List<Association> getCurrentPath() {
        return RuntimePersistentAssociationPath.associated(this.getAssociations(), this.association);
    }

    private static List<Association> associated(List<Association> associations, Association association) {
        ArrayList<Association> newAssociations = new ArrayList<Association>(associations.size() + 1);
        newAssociations.addAll(associations);
        newAssociations.add(association);
        return newAssociations;
    }

    public Attribute<? super Owner, ?> getAttribute() {
        return super.getAttribute();
    }

    public JoinType getJoinType() {
        return super.getJoinType();
    }

    public String toString() {
        return "RuntimePersistentAssociationPath{parent=" + String.valueOf(this.parent) + ", association=" + String.valueOf(this.association) + ", associations=" + String.valueOf(this.associations) + "}";
    }
}

