/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.criteria;

import io.micronaut.context.ApplicationContext;
import io.micronaut.data.event.EntityEventListener;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaDelete;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaInsert;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaUpdate;
import io.micronaut.data.model.jpa.criteria.impl.AbstractCriteriaBuilder;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.criteria.RuntimePersistentEntityCriteriaDelete;
import io.micronaut.data.runtime.criteria.RuntimePersistentEntityCriteriaInsert;
import io.micronaut.data.runtime.criteria.RuntimePersistentEntityCriteriaQuery;
import io.micronaut.data.runtime.criteria.RuntimePersistentEntityCriteriaUpdate;
import io.micronaut.data.runtime.criteria.metamodel.StaticMetamodelInitializer;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.Expression;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.NonNull;

@Singleton
public final class RuntimeCriteriaBuilder
extends AbstractCriteriaBuilder {
    private final RuntimeEntityRegistry runtimeEntityRegistry;
    private final StaticMetamodelInitializer staticMetamodelInitializer = new StaticMetamodelInitializer();

    public RuntimeCriteriaBuilder() {
        this(new RuntimeEntityRegistry(){
            private final Map<Class, RuntimePersistentEntity> map = new HashMap<Class, RuntimePersistentEntity>();

            public EntityEventListener<Object> getEntityEventListener() {
                throw new IllegalStateException("EntityEventListeners are not yet supported");
            }

            public Object autoPopulateRuntimeProperty(RuntimePersistentProperty<?> persistentProperty, Object previousValue) {
                throw new IllegalStateException("AutoPopulateRuntimeProperty are not yet supported");
            }

            public <T> RuntimePersistentEntity<T> getEntity(Class<T> type) {
                final 1 entityRegistry = this;
                return this.map.computeIfAbsent(type, t -> new RuntimePersistentEntity<Object>(this, t){

                    protected RuntimePersistentEntity<Object> getEntity(Class<Object> type) {
                        return entityRegistry.getEntity(type);
                    }
                });
            }

            public <T> RuntimePersistentEntity<T> newEntity(Class<T> type) {
                return new RuntimePersistentEntity(type);
            }

            public @NonNull ApplicationContext getApplicationContext() {
                throw new IllegalStateException("ApplicationContext are not yet supported");
            }
        });
    }

    @Inject
    public RuntimeCriteriaBuilder(RuntimeEntityRegistry runtimeEntityRegistry) {
        this.runtimeEntityRegistry = runtimeEntityRegistry;
    }

    public PersistentEntityCriteriaQuery<Object> createQuery() {
        return new RuntimePersistentEntityCriteriaQuery<Object>(this, this.staticMetamodelInitializer, Object.class, this.runtimeEntityRegistry);
    }

    public PersistentEntityCriteriaQuery<Tuple> createTupleQuery() {
        return new RuntimePersistentEntityCriteriaQuery<Tuple>(this, this.staticMetamodelInitializer, Tuple.class, this.runtimeEntityRegistry);
    }

    public <T> PersistentEntityCriteriaQuery<T> createQuery(Class<T> resultClass) {
        return new RuntimePersistentEntityCriteriaQuery<T>(this, this.staticMetamodelInitializer, resultClass, this.runtimeEntityRegistry);
    }

    public <T> PersistentEntityCriteriaUpdate<T> createCriteriaUpdate(Class<T> targetEntity) {
        return new RuntimePersistentEntityCriteriaUpdate<T>(this, targetEntity, this.runtimeEntityRegistry, this.staticMetamodelInitializer);
    }

    public <T> PersistentEntityCriteriaDelete<T> createCriteriaDelete(Class<T> targetEntity) {
        return new RuntimePersistentEntityCriteriaDelete<T>(this, targetEntity, this.runtimeEntityRegistry, this.staticMetamodelInitializer);
    }

    public <T> PersistentEntityCriteriaInsert<T> createCriteriaInsert(Class<T> targetEntity) {
        return new RuntimePersistentEntityCriteriaInsert<T>(this, targetEntity, this.runtimeEntityRegistry, this.staticMetamodelInitializer);
    }

    public <T> Expression<T> literal(T value) {
        return super.parameter(value == null ? Object.class : value.getClass(), null, value);
    }

    public RuntimeEntityRegistry getRuntimeEntityRegistry() {
        return this.runtimeEntityRegistry;
    }
}

