/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.convert;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.data.repository.jpa.criteria.PredicateSpecification;
import io.micronaut.data.runtime.date.DateTimeProvider;
import jakarta.data.constraint.AtLeast;
import jakarta.data.constraint.AtMost;
import jakarta.data.constraint.Between;
import jakarta.data.constraint.Constraint;
import jakarta.data.constraint.EqualTo;
import jakarta.data.constraint.GreaterThan;
import jakarta.data.constraint.In;
import jakarta.data.constraint.LessThan;
import jakarta.data.constraint.Like;
import jakarta.data.constraint.NotBetween;
import jakarta.data.constraint.NotEqualTo;
import jakarta.data.constraint.NotIn;
import jakarta.data.constraint.NotLike;
import jakarta.data.constraint.NotNull;
import jakarta.data.constraint.Null;
import jakarta.data.expression.Expression;
import jakarta.data.expression.NavigableExpression;
import jakarta.data.metamodel.Attribute;
import jakarta.data.metamodel.NavigableAttribute;
import jakarta.data.restrict.BasicRestriction;
import jakarta.data.restrict.CompositeRestriction;
import jakarta.data.restrict.Restriction;
import jakarta.data.spi.expression.function.CurrentDate;
import jakarta.data.spi.expression.function.CurrentDateTime;
import jakarta.data.spi.expression.function.CurrentTime;
import jakarta.data.spi.expression.function.FunctionExpression;
import jakarta.data.spi.expression.function.NumericFunctionExpression;
import jakarta.data.spi.expression.function.NumericOperatorExpression;
import jakarta.data.spi.expression.function.TextFunctionExpression;
import jakarta.data.spi.expression.literal.Literal;
import jakarta.data.spi.expression.path.NavigablePath;
import jakarta.data.spi.expression.path.Path;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.lang.runtime.SwitchBootstraps;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

@Internal
final class JakartaDataRestrictionsConverter<T>
implements TypeConverter<Restriction<T>, PredicateSpecification<T>> {
    private final DateTimeProvider<OffsetDateTime> dateTimeProvider;

    JakartaDataRestrictionsConverter(DateTimeProvider<OffsetDateTime> dateTimeProvider) {
        this.dateTimeProvider = dateTimeProvider;
    }

    public Optional<PredicateSpecification<T>> convert(Restriction<T> restriction, Class<PredicateSpecification<T>> targetType, ConversionContext context) {
        if (!(context instanceof ArgumentConversionContext)) {
            throw new IllegalArgumentException("ConversionContext must be an ArgumentConversionContext");
        }
        ArgumentConversionContext argumentConversionContext = (ArgumentConversionContext)context;
        Optional rootEntityType = argumentConversionContext.getArgument().getFirstTypeVariable();
        if (rootEntityType.isEmpty()) {
            throw new IllegalArgumentException("Argument must have a generic type");
        }
        return Optional.of((root, criteriaBuilder) -> {
            if (restriction == null) {
                return null;
            }
            return this.toPredicate(root, criteriaBuilder, restriction);
        });
    }

    private <R> Predicate toPredicate(Root<T> root, CriteriaBuilder criteriaBuilder, Restriction<R> restriction) {
        Restriction<R> restriction2 = restriction;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CompositeRestriction.class, BasicRestriction.class}, restriction2, n)) {
            case 0 -> {
                CompositeRestriction compositeRestriction = (CompositeRestriction)restriction2;
                yield this.predicateFromCompositeRestriction(root, criteriaBuilder, compositeRestriction);
            }
            case 1 -> {
                BasicRestriction basicRestriction = (BasicRestriction)restriction2;
                yield this.predicateFromBasicRestriction(root, criteriaBuilder, basicRestriction);
            }
            default -> throw new IllegalStateException("Unknown Restriction: " + String.valueOf(restriction) + " of type " + String.valueOf(restriction.getClass()));
        };
    }

    private <R> Predicate predicateFromCompositeRestriction(Root<T> root, CriteriaBuilder criteriaBuilder, CompositeRestriction<R> compositeRestriction) {
        List restrictions = compositeRestriction.restrictions();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>(restrictions.size());
        for (Restriction combinedRestriction : restrictions) {
            predicates.add(this.toPredicate(root, criteriaBuilder, combinedRestriction));
        }
        Predicate predicate = compositeRestriction.type() == CompositeRestriction.Type.ANY ? criteriaBuilder.or(predicates.toArray(new Predicate[0])) : criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        if (compositeRestriction.isNegated()) {
            return predicate.not();
        }
        return predicate;
    }

    private <V> Predicate predicateFromBasicRestriction(Root<T> root, CriteriaBuilder criteriaBuilder, BasicRestriction<?, V> basicRestriction) {
        return this.toPredicate(root, criteriaBuilder, basicRestriction.constraint(), this.asExpression(root, criteriaBuilder, basicRestriction.expression()));
    }

    public <V> Predicate toPredicate(Root<T> root, CriteriaBuilder criteriaBuilder, Constraint<V> constraint, jakarta.persistence.criteria.Expression<V> expression) {
        Constraint<V> constraint2 = constraint;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EqualTo.class, NotEqualTo.class, GreaterThan.class, LessThan.class, AtLeast.class, AtMost.class, Between.class, NotBetween.class, In.class, NotIn.class, Null.class, NotNull.class, Like.class, NotLike.class}, constraint2, n)) {
            case 0 -> {
                EqualTo equalTo = (EqualTo)constraint2;
                yield criteriaBuilder.equal(expression, this.asExpression(root, criteriaBuilder, equalTo.expression()));
            }
            case 1 -> {
                NotEqualTo notEqualTo = (NotEqualTo)constraint2;
                yield criteriaBuilder.notEqual(expression, this.asExpression(root, criteriaBuilder, notEqualTo.expression()));
            }
            case 2 -> {
                GreaterThan greaterThan = (GreaterThan)constraint2;
                yield criteriaBuilder.greaterThan(expression, this.asExpression(root, criteriaBuilder, (Expression<?, V>)greaterThan.bound()));
            }
            case 3 -> {
                LessThan lessThan = (LessThan)constraint2;
                yield criteriaBuilder.lessThan(expression, this.asExpression(root, criteriaBuilder, (Expression<?, V>)lessThan.bound()));
            }
            case 4 -> {
                AtLeast atLeast = (AtLeast)constraint2;
                yield criteriaBuilder.greaterThanOrEqualTo(expression, this.asExpression(root, criteriaBuilder, (Expression<?, V>)atLeast.bound()));
            }
            case 5 -> {
                AtMost atMost = (AtMost)constraint2;
                yield criteriaBuilder.lessThanOrEqualTo(expression, this.asExpression(root, criteriaBuilder, (Expression<?, V>)atMost.bound()));
            }
            case 6 -> {
                Between between = (Between)constraint2;
                yield criteriaBuilder.between(expression, this.asExpression(root, criteriaBuilder, (Expression<?, V>)between.lowerBound()), this.asExpression(root, criteriaBuilder, (Expression<?, V>)between.upperBound()));
            }
            case 7 -> {
                NotBetween notBetween = (NotBetween)constraint2;
                yield criteriaBuilder.not((jakarta.persistence.criteria.Expression)criteriaBuilder.between(expression, this.asExpression(root, criteriaBuilder, (Expression<?, V>)notBetween.lowerBound()), this.asExpression(root, criteriaBuilder, (Expression<?, V>)notBetween.upperBound())));
            }
            case 8 -> {
                In in = (In)constraint2;
                yield expression.in(this.asExpressionList(root, criteriaBuilder, in.expressions()));
            }
            case 9 -> {
                NotIn notIn = (NotIn)constraint2;
                yield criteriaBuilder.not((jakarta.persistence.criteria.Expression)expression.in(this.asExpressionList(root, criteriaBuilder, notIn.expressions())));
            }
            case 10 -> {
                Null ignored = (Null)constraint2;
                yield criteriaBuilder.isNull(expression);
            }
            case 11 -> {
                NotNull ignored = (NotNull)constraint2;
                yield criteriaBuilder.isNotNull(expression);
            }
            case 12 -> {
                Like like = (Like)constraint2;
                yield criteriaBuilder.like(expression, this.asExpression(root, criteriaBuilder, (Expression<?, V>)like.pattern()));
            }
            case 13 -> {
                NotLike notLike = (NotLike)constraint2;
                yield criteriaBuilder.not((jakarta.persistence.criteria.Expression)criteriaBuilder.like(expression, this.asExpression(root, criteriaBuilder, (Expression<?, V>)notLike.pattern())));
            }
            default -> throw new IllegalStateException("Unknown constraint: " + String.valueOf(constraint) + " of type: " + String.valueOf(constraint.getClass()));
        };
    }

    private <V> Collection<?> asExpressionList(Root<T> root, CriteriaBuilder criteriaBuilder, List<Expression<?, V>> expressions) {
        ArrayList<jakarta.persistence.criteria.Expression<V>> result = new ArrayList<jakarta.persistence.criteria.Expression<V>>(expressions.size());
        for (Expression<?, V> expression : expressions) {
            result.add(this.asExpression(root, criteriaBuilder, expression));
        }
        return result;
    }

    private <V> jakarta.persistence.criteria.Expression<V> asExpression(Root<?> root, CriteriaBuilder criteriaBuilder, Expression<?, V> expression) {
        Expression<?, V> expression2 = expression;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Attribute.class, Literal.class, Path.class, CurrentDateTime.class, CurrentDate.class, CurrentTime.class, TextFunctionExpression.class, NumericFunctionExpression.class, NumericOperatorExpression.class}, expression2, n)) {
            case 0 -> {
                Attribute attribute = (Attribute)expression2;
                yield root.get(attribute.name());
            }
            case 1 -> {
                Literal literal = (Literal)expression2;
                yield criteriaBuilder.literal(literal.value());
            }
            case 2 -> {
                Path path = (Path)expression2;
                yield this.asPath((jakarta.persistence.criteria.Path<?>)root, (Path<?, ?>)path).get(path.attribute().name());
            }
            case 3 -> {
                CurrentDateTime ignore = (CurrentDateTime)expression2;
                yield criteriaBuilder.literal((Object)this.dateTimeProvider.getNow().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
            }
            case 4 -> {
                CurrentDate ignore = (CurrentDate)expression2;
                yield criteriaBuilder.literal((Object)this.dateTimeProvider.getNow().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            }
            case 5 -> {
                CurrentTime ignore = (CurrentTime)expression2;
                yield criteriaBuilder.literal((Object)this.dateTimeProvider.getNow().toInstant().atZone(ZoneId.systemDefault()).toLocalTime());
            }
            case 6 -> {
                TextFunctionExpression textFunctionExpression = (TextFunctionExpression)expression2;
                yield criteriaBuilder.function(textFunctionExpression.name(), String.class, this.asExpressions(root, criteriaBuilder, (FunctionExpression<?, ?>)textFunctionExpression));
            }
            case 7 -> {
                NumericFunctionExpression numericFunctionExpression = (NumericFunctionExpression)expression2;
                yield criteriaBuilder.function(numericFunctionExpression.name(), Number.class, this.asExpressions(root, criteriaBuilder, (FunctionExpression<?, ?>)numericFunctionExpression));
            }
            case 8 -> {
                NumericOperatorExpression numericOperatorExpression = (NumericOperatorExpression)expression2;
                jakarta.persistence.criteria.Expression<V> left = this.asExpression(root, criteriaBuilder, numericOperatorExpression.left());
                jakarta.persistence.criteria.Expression<V> right = this.asExpression(root, criteriaBuilder, numericOperatorExpression.right());
                switch (numericOperatorExpression.operator()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case PLUS: {
                        yield criteriaBuilder.sum(left, right);
                    }
                    case MINUS: {
                        yield criteriaBuilder.diff(left, right);
                    }
                    case TIMES: {
                        yield criteriaBuilder.prod(left, right);
                    }
                    case DIVIDE: 
                }
                yield criteriaBuilder.quot(left, right);
            }
            default -> throw new IllegalStateException("Unknown Expression: " + String.valueOf(expression) + " of type: " + String.valueOf(expression.getClass()));
        };
    }

    private jakarta.persistence.criteria.Expression<?>[] asExpressions(Root<?> root, CriteriaBuilder criteriaBuilder, FunctionExpression<?, ?> textFunctionExpression) {
        List arguments = textFunctionExpression.arguments();
        ArrayList list = new ArrayList(arguments.size());
        for (Expression a : arguments) {
            jakarta.persistence.criteria.Expression expression = this.asExpression(root, criteriaBuilder, a);
            list.add(expression);
        }
        return list.toArray(new jakarta.persistence.criteria.Expression[0]);
    }

    private <V> jakarta.persistence.criteria.Path<V> asPath(jakarta.persistence.criteria.Path<?> criteriaPath, Path<?, ?> path) {
        NavigableExpression navigableExpression = path.expression();
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NavigableAttribute.class, NavigablePath.class}, (Object)navigableExpression, n)) {
            case 0 -> {
                NavigableAttribute navigableAttribute = (NavigableAttribute)navigableExpression;
                yield criteriaPath.get(navigableAttribute.name());
            }
            case 1 -> {
                NavigablePath navigablePath = (NavigablePath)navigableExpression;
                yield this.asPath(criteriaPath, (Path<?, ?>)navigablePath);
            }
            default -> throw new IllegalStateException("Unknown Path: " + String.valueOf(path) + " of type: " + String.valueOf(path.getClass()));
        };
    }
}

