/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria.async;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.criteria.AbstractSpecificationInterceptor;
import io.micronaut.data.runtime.intercept.criteria.async.AbstractAsyncSpecificationInterceptor;
import java.util.Collections;
import java.util.concurrent.CompletionStage;

@Internal
public class FindAllAsyncSpecificationInterceptor
extends AbstractAsyncSpecificationInterceptor<Object, Object> {
    protected FindAllAsyncSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        CompletionStage<Iterable<Object>> future = this.findAllAsync(methodKey, context, AbstractSpecificationInterceptor.Type.FIND_ALL);
        return future.thenApply(iterable -> {
            Argument<?> argument = this.findReturnType(context, LIST_OF_OBJECTS);
            if (argument.getType().isInstance(iterable)) {
                return iterable;
            }
            Iterable result = this.operations.getConversionService().convert(iterable, argument).orElse(null);
            return result == null ? Collections.emptyList() : result;
        });
    }
}

