/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.async;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncCapableRepository;
import io.micronaut.data.operations.async.AsyncRepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import java.util.List;
import java.util.concurrent.CompletionStage;

public abstract class AbstractAsyncInterceptor<T, R>
extends AbstractQueryInterceptor<T, CompletionStage<R>> {
    protected static final Argument<List<Object>> LIST_OF_OBJECTS = Argument.listOf(Object.class);
    @NonNull
    protected final AsyncRepositoryOperations asyncDatastoreOperations;

    protected AbstractAsyncInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
        if (!(datastore instanceof AsyncCapableRepository)) {
            throw new DataAccessException("Datastore of type [" + datastore.getClass() + "] does not support asynchronous operations");
        }
        AsyncCapableRepository asyncCapableRepository = (AsyncCapableRepository)datastore;
        this.asyncDatastoreOperations = asyncCapableRepository.async();
    }

    @Override
    protected final Argument<?> getReturnType(MethodInvocationContext<?, ?> context) {
        return this.findReturnType(context, Argument.OBJECT_ARGUMENT);
    }

    protected final Argument<?> findReturnType(MethodInvocationContext<?, ?> context, Argument<?> defaultArg) {
        ReturnType returnType = context.getReturnType();
        if (context.isSuspend() && !returnType.getType().getName().equals("kotlinx.coroutines.flow.Flow")) {
            return returnType.asArgument();
        }
        return returnType.asArgument().getFirstTypeVariable().orElse(defaultArg);
    }

    @Nullable
    protected Number convertNumberToReturnType(MethodInvocationContext<?, ?> context, Number number) {
        Argument<?> firstTypeVar = this.findReturnType(context, Argument.LONG);
        Class type = firstTypeVar.getType();
        if (type == Object.class || type == Void.class || type == Void.TYPE) {
            return null;
        }
        if (number == null) {
            number = 0;
        }
        if (!type.isInstance(number)) {
            return (Number)this.operations.getConversionService().convert((Object)number, firstTypeVar).orElseThrow(() -> new IllegalStateException("Unsupported number type for return type: " + firstTypeVar));
        }
        return number;
    }
}

