/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.RepositoryOperationsRegistry;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.inject.Singleton;

@Internal
@Singleton
class DefaultRepositoryOperationsRegistry
implements RepositoryOperationsRegistry {
    private final BeanLocator locator;

    DefaultRepositoryOperationsRegistry(BeanLocator locator) {
        this.locator = locator;
    }

    public <T extends RepositoryOperations> T provide(Class<T> repositoryOperationsType, String dataSourceName) {
        if (dataSourceName != null) {
            try {
                return (T)((RepositoryOperations)this.locator.getBean(repositoryOperationsType, Qualifiers.byName((String)dataSourceName)));
            }
            catch (NoSuchBeanException e) {
                throw new ConfigurationException("No backing RepositoryOperations configured for repository for datasource: [" + dataSourceName + "]. Check your configuration and try again", (Throwable)e);
            }
        }
        try {
            return (T)((RepositoryOperations)this.locator.getBean(repositoryOperationsType));
        }
        catch (NoSuchBeanException e) {
            throw new ConfigurationException("No backing RepositoryOperations configured for repository. Check your configuration and try again", (Throwable)e);
        }
    }
}

