/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.criteria;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.jpa.criteria.PersistentAssociationPath;
import io.micronaut.data.model.jpa.criteria.PersistentEntityPath;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.criteria.RuntimePersistentPropertyPathImpl;
import jakarta.persistence.criteria.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Internal
interface RuntimePersistentEntityPath<T>
extends PersistentEntityPath<T> {
    public RuntimePersistentEntity<T> getPersistentEntity();

    default public <Y> PersistentPropertyPath<Y> get(String attributeName) {
        RuntimePersistentProperty property = this.getPersistentEntity().getPropertyByName(attributeName);
        if (property == null) {
            throw new IllegalStateException("Cannot query entity [" + this.getPersistentEntity().getSimpleName() + "] on non-existent property: " + attributeName);
        }
        if (this instanceof PersistentAssociationPath) {
            PersistentAssociationPath associationPath = (PersistentAssociationPath)this;
            List associations = associationPath.getAssociations();
            ArrayList<Association> newAssociations = new ArrayList<Association>(associations.size() + 1);
            newAssociations.addAll(associations);
            newAssociations.add(associationPath.getAssociation());
            return new RuntimePersistentPropertyPathImpl((Path<?>)this, (List<Association>)newAssociations, property);
        }
        return new RuntimePersistentPropertyPathImpl((Path<?>)this, Collections.emptyList(), property);
    }
}

