/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal.sql;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.runtime.mapper.sql.SqlJsonColumnReader;
import io.micronaut.data.runtime.mapper.sql.SqlJsonValueMapper;
import io.micronaut.data.runtime.operations.internal.sql.SqlPreparedQuery;
import io.micronaut.data.runtime.operations.internal.sql.SqlStoredQuery;
import io.micronaut.json.JsonMapper;
import jakarta.inject.Singleton;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@Singleton
public final class SqlJsonColumnMapperProvider<S> {
    private static final Logger LOG = LoggerFactory.getLogger(SqlJsonColumnMapperProvider.class);
    private final List<SqlJsonColumnReader<S>> sqlJsonColumnReaders;
    private final List<SqlJsonValueMapper> sqlJsonValueMappers;
    private final SqlJsonColumnReader<S> defaultSqlJsonColumnReader;
    private final SqlJsonValueMapper defaultSqlJsonValueMapper;

    public SqlJsonColumnMapperProvider(@Nullable JsonMapper jsonMapper, List<SqlJsonColumnReader<S>> sqlJsonColumnReaders, List<SqlJsonValueMapper> sqlJsonValueMappers) {
        this.sqlJsonColumnReaders = sqlJsonColumnReaders;
        this.sqlJsonValueMappers = sqlJsonValueMappers;
        if (jsonMapper == null) {
            this.defaultSqlJsonColumnReader = null;
            this.defaultSqlJsonValueMapper = null;
        } else {
            this.defaultSqlJsonColumnReader = () -> jsonMapper;
            this.defaultSqlJsonValueMapper = () -> jsonMapper;
        }
    }

    public SqlJsonColumnReader<S> getJsonColumnReader(SqlPreparedQuery<?, ?> sqlPreparedQuery, Class<S> resultSetType) {
        SqlJsonColumnReader<S> supportedSqlJsonColumnReader = null;
        for (SqlJsonColumnReader<S> sqlJsonColumnReader : this.sqlJsonColumnReaders) {
            if (!sqlJsonColumnReader.supportsResultSetType(resultSetType) || !sqlJsonColumnReader.supportsRead(sqlPreparedQuery)) continue;
            supportedSqlJsonColumnReader = sqlJsonColumnReader;
            break;
        }
        if (supportedSqlJsonColumnReader != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using custom JSON column reader for dialect {}", (Object)sqlPreparedQuery.getDialect());
            }
            return supportedSqlJsonColumnReader;
        }
        if (this.defaultSqlJsonColumnReader == null && LOG.isDebugEnabled()) {
            LOG.debug("No default SqlJsonColumnReader found for dialect {}. Need to add Micronaut JsonMapper to the classpath.", (Object)sqlPreparedQuery.getDialect());
        }
        return this.defaultSqlJsonColumnReader;
    }

    public SqlJsonValueMapper getJsonValueMapper(SqlStoredQuery<?, ?> sqlStoredQuery, JsonDataType jsonDataType, Object value) {
        if (value == null || value.getClass().equals(String.class)) {
            return this.defaultSqlJsonValueMapper;
        }
        SqlJsonValueMapper supportedSqlJsonValueMapper = null;
        for (SqlJsonValueMapper sqlJsonValueMapper : this.sqlJsonValueMappers) {
            if (!sqlJsonValueMapper.supportsMapValue(sqlStoredQuery, jsonDataType)) continue;
            supportedSqlJsonValueMapper = sqlJsonValueMapper;
            break;
        }
        if (supportedSqlJsonValueMapper != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using custom JSON column value mapper for dialect {}", (Object)sqlStoredQuery.getDialect());
            }
            return supportedSqlJsonValueMapper;
        }
        if (this.defaultSqlJsonValueMapper == null && LOG.isDebugEnabled()) {
            LOG.debug("No default SqlJsonValueMapper found for dialect {}. Need to add Micronaut JsonMapper to the classpath.", (Object)sqlStoredQuery.getDialect());
        }
        return this.defaultSqlJsonValueMapper;
    }
}

