/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.event.listeners;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.data.event.EntityEventListener;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public abstract class AutoPopulatedEntityEventListener
implements EntityEventListener<Object> {
    private final Map<RuntimePersistentEntity<Object>, RuntimePersistentProperty<Object>[]> applicableProperties = new ConcurrentHashMap<RuntimePersistentEntity<Object>, RuntimePersistentProperty<Object>[]>(30);

    public final boolean supports(RuntimePersistentEntity<Object> entity, Class<? extends Annotation> eventType) {
        if (this.getEventTypes().contains(eventType) && entity.hasAutoPopulatedProperties()) {
            Object[] properties = this.applicableProperties.get(entity);
            if (properties == null) {
                RuntimePersistentProperty[] compositeIdentity;
                Collection persistentProperties = entity.getPersistentProperties();
                ArrayList<RuntimePersistentProperty> propertyList = new ArrayList<RuntimePersistentProperty>(persistentProperties.size());
                RuntimePersistentProperty identity = entity.getIdentity();
                if (identity != null && identity.isAutoPopulated()) {
                    propertyList.add(identity);
                }
                if ((compositeIdentity = entity.getCompositeIdentity()) != null) {
                    for (RuntimePersistentProperty compositeId : compositeIdentity) {
                        if (!compositeId.isAutoPopulated()) continue;
                        propertyList.add(compositeId);
                    }
                }
                propertyList.addAll(persistentProperties.stream().filter(PersistentProperty::isAutoPopulated).toList());
                properties = (RuntimePersistentProperty[])propertyList.stream().filter(this.getPropertyPredicate()).toArray(RuntimePersistentProperty[]::new);
                if (ArrayUtils.isEmpty((Object[])properties)) {
                    this.applicableProperties.put(entity, RuntimePersistentProperty.EMPTY_PROPERTY_ARRAY);
                } else {
                    this.applicableProperties.put(entity, (RuntimePersistentProperty<Object>[])properties);
                }
            }
            return true;
        }
        return false;
    }

    @NonNull
    protected abstract List<Class<? extends Annotation>> getEventTypes();

    @NonNull
    protected abstract Predicate<RuntimePersistentProperty<Object>> getPropertyPredicate();

    @NonNull
    protected RuntimePersistentProperty<Object>[] getApplicableProperties(RuntimePersistentEntity<Object> entity) {
        RuntimePersistentProperty<Object>[] properties = this.applicableProperties.get(entity);
        if (properties != null) {
            return properties;
        }
        return RuntimePersistentProperty.EMPTY_PROPERTY_ARRAY;
    }
}

