/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.mapper;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.runtime.mapper.TypeMapper;
import java.sql.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

@FunctionalInterface
public interface BeanIntrospectionMapper<D, R>
extends TypeMapper<D, R> {
    @Override
    @NonNull
    default public R map(@NonNull D object, @NonNull Class<R> type) throws InstantiationException {
        ArgumentUtils.requireNonNull((String)"resultSet", object);
        ArgumentUtils.requireNonNull((String)"type", type);
        try {
            Object instance;
            BeanIntrospection introspection = BeanIntrospection.getIntrospection(type);
            Object[] arguments = introspection.getConstructorArguments();
            if (ArrayUtils.isEmpty((Object[])arguments)) {
                instance = introspection.instantiate();
            } else {
                Object[] args = new Object[arguments.length];
                for (int i = 0; i < arguments.length; ++i) {
                    Object argument = arguments[i];
                    Set<Object> o = this.read(object, (Argument<?>)argument);
                    if (o == null) {
                        args[i] = o;
                        continue;
                    }
                    if (argument.getType().isInstance(o)) {
                        args[i] = o;
                        continue;
                    }
                    Set<Object> convertFrom = Collection.class.isAssignableFrom(argument.getType()) && !(o instanceof Collection) ? Collections.singleton(o) : o;
                    args[i] = this.convert(convertFrom, (Argument<?>)argument);
                }
                instance = introspection.instantiate(args);
            }
            Collection properties = introspection.getBeanProperties();
            for (BeanProperty property : properties) {
                Object v;
                if (property.isReadOnly() || (v = this.read(object, property.getName())) == null) continue;
                if (property.getType().isInstance(v)) {
                    property.set(instance, v);
                    continue;
                }
                if (Iterable.class.isAssignableFrom(property.getType())) {
                    Object[] arr;
                    Collection<Object> collection;
                    Object value = property.get(instance);
                    if (v instanceof Collection) {
                        collection = (ArrayList)v;
                    } else if (v instanceof Iterable) {
                        collection = new ArrayList(CollectionUtils.iterableToList((Iterable)((Iterable)v)));
                    } else if (v.getClass().isArray()) {
                        arr = (Object[])v;
                        collection = Arrays.asList(arr);
                    } else if (v instanceof Array) {
                        try {
                            arr = (Object[])((Array)v).getArray();
                        }
                        catch (SQLException e) {
                            throw new DataAccessException("Unable to read SQL array", (Throwable)e);
                        }
                        collection = Arrays.asList(arr);
                    } else {
                        collection = Collections.singleton(v);
                    }
                    if (value instanceof Collection) {
                        ((Collection)value).addAll(collection);
                        continue;
                    }
                    if (value instanceof Iterable) {
                        ArrayList list = new ArrayList(CollectionUtils.iterableToList((Iterable)((Iterable)value)));
                        list.addAll(collection);
                        property.set(instance, this.convert(list, property.asArgument()));
                        continue;
                    }
                    property.set(instance, this.convert(collection, property.asArgument()));
                    continue;
                }
                property.set(instance, this.convert(v, property.asArgument()));
            }
            return (R)instance;
        }
        catch (IntrospectionException | InstantiationException e) {
            throw new DataAccessException("Error instantiating type [" + type.getName() + "] from introspection: " + e.getMessage(), e);
        }
    }

    default public Object convert(Object value, Argument<?> argument) {
        if (value == null) {
            return null;
        }
        ArgumentConversionContext acc = ConversionContext.of(argument);
        Optional result = this.getConversionService().convert(value, argument);
        if (!result.isPresent()) {
            Optional lastError = acc.getLastError();
            if (lastError.isPresent()) {
                throw new ConversionErrorException(argument, (ConversionError)lastError.get());
            }
            throw new IllegalArgumentException("Cannot convert object type " + value.getClass() + " to required type: " + argument.getType());
        }
        return result.get();
    }
}

