/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.async;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.async.DeleteOneAsyncInterceptor;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.async.AbstractAsyncInterceptor;
import java.util.concurrent.CompletionStage;

public class DefaultDeleteOneAsyncInterceptor<T>
extends AbstractAsyncInterceptor<T, Number>
implements DeleteOneAsyncInterceptor<T> {
    protected DefaultDeleteOneAsyncInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    public CompletionStage<Number> intercept(RepositoryMethodKey methodKey, MethodInvocationContext<T, CompletionStage<Number>> context) {
        Object[] parameterValues = context.getParameterValues();
        if (parameterValues.length == 1) {
            Object o = parameterValues[0];
            if (o != null) {
                DeleteOperation<Object> deleteOperation = this.getDeleteOperation(context, o);
                return this.asyncDatastoreOperations.delete(deleteOperation).thenApply(n -> 1);
            }
            throw new IllegalArgumentException("Entity to delete cannot be null");
        }
        throw new IllegalStateException("Expected exactly one argument");
    }
}

