/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.mapper.sql;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.annotation.TypeDef;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.data.runtime.mapper.sql.SqlTypeMapper;
import io.micronaut.http.codec.MediaTypeCodec;
import java.sql.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Internal
public final class SqlResultEntityTypeMapper<RS, R>
implements SqlTypeMapper<RS, R> {
    private final RuntimePersistentEntity<R> entity;
    private final ResultReader<RS, String> resultReader;
    private final Map<String, JoinPath> joinPaths;
    private final String startingPrefix;
    private final MediaTypeCodec jsonCodec;
    private boolean callNext = true;

    public SqlResultEntityTypeMapper(@NonNull RuntimePersistentEntity<R> entity, @NonNull ResultReader<RS, String> resultReader, @Nullable MediaTypeCodec jsonCodec) {
        this(entity, resultReader, Collections.emptySet(), jsonCodec);
    }

    public SqlResultEntityTypeMapper(String prefix, @NonNull RuntimePersistentEntity<R> entity, @NonNull ResultReader<RS, String> resultReader, @Nullable MediaTypeCodec jsonCodec) {
        this(entity, resultReader, Collections.emptySet(), prefix, jsonCodec);
    }

    public SqlResultEntityTypeMapper(@NonNull RuntimePersistentEntity<R> entity, @NonNull ResultReader<RS, String> resultReader, @Nullable Set<JoinPath> joinPaths, @Nullable MediaTypeCodec jsonCodec) {
        this(entity, resultReader, joinPaths, null, jsonCodec);
    }

    private SqlResultEntityTypeMapper(@NonNull RuntimePersistentEntity<R> entity, @NonNull ResultReader<RS, String> resultReader, @Nullable Set<JoinPath> joinPaths, String startingPrefix, @Nullable MediaTypeCodec jsonCodec) {
        ArgumentUtils.requireNonNull((String)"entity", entity);
        ArgumentUtils.requireNonNull((String)"resultReader", resultReader);
        this.entity = entity;
        this.jsonCodec = jsonCodec;
        this.resultReader = resultReader;
        if (CollectionUtils.isNotEmpty(joinPaths)) {
            this.joinPaths = new HashMap<String, JoinPath>(joinPaths.size());
            for (JoinPath joinPath : joinPaths) {
                this.joinPaths.put(joinPath.getPath(), joinPath);
            }
        } else {
            this.joinPaths = Collections.emptyMap();
        }
        this.startingPrefix = startingPrefix;
    }

    @NonNull
    public RuntimePersistentEntity<R> getEntity() {
        return this.entity;
    }

    @NonNull
    public ResultReader<RS, String> getResultReader() {
        return this.resultReader;
    }

    @Override
    @NonNull
    public R map(@NonNull RS object, @NonNull Class<R> type) throws DataAccessException {
        return this.readEntity(this.startingPrefix, null, object, this.entity, false, null, null, null);
    }

    @Override
    @Nullable
    public Object read(@NonNull RS resultSet, @NonNull String name) {
        RuntimePersistentProperty property = this.entity.getPropertyByName(name);
        if (property == null) {
            throw new DataAccessException("DTO projection defines a property [" + name + "] that doesn't exist on root entity: " + this.entity.getName());
        }
        DataType dataType = property.getDataType();
        String columnName = property.getPersistedName();
        return this.resultReader.readDynamic(resultSet, columnName, dataType);
    }

    @Override
    @Nullable
    public Object read(@NonNull RS resultSet, @NonNull Argument<?> argument) {
        String columnName;
        DataType dataType;
        RuntimePersistentProperty property = this.entity.getPropertyByName(argument.getName());
        if (property == null) {
            dataType = argument.getAnnotationMetadata().enumValue(TypeDef.class, "type", DataType.class).orElseGet(() -> DataType.forType((Class)argument.getType()));
            columnName = argument.getName();
        } else {
            dataType = property.getDataType();
            columnName = property.getPersistedName();
        }
        return this.resultReader.readDynamic(resultSet, columnName, dataType);
    }

    @Override
    public boolean hasNext(RS resultSet) {
        if (this.callNext) {
            return this.resultReader.next(resultSet);
        }
        try {
            boolean bl = true;
            return bl;
        }
        finally {
            this.callNext = true;
        }
    }

    private R readEntity(String prefix, String path, RS rs, RuntimePersistentEntity<R> persistentEntity, boolean isEmbedded, @Nullable Association association, @Nullable Object parent, @Nullable Object resolveId) {
        BeanIntrospection introspection = persistentEntity.getIntrospection();
        Object[] constructorArguments = persistentEntity.getConstructorArguments();
        try {
            BeanProperty idProperty;
            Relation.Kind kind;
            Object entity;
            boolean nullableEmbedded;
            Object id = resolveId;
            RuntimePersistentProperty identity = persistentEntity.getIdentity();
            boolean hasPrefix = prefix != null;
            boolean hasPath = path != null;
            boolean isAssociation = association != null;
            boolean bl = nullableEmbedded = association instanceof Embedded && association.isOptional();
            if (id == null && identity != null) {
                if (identity instanceof Embedded) {
                    PersistentEntity embeddedEntity = ((Embedded)identity).getAssociatedEntity();
                    id = this.readEntity(identity.getPersistedName() + "_", (hasPath ? path : "") + identity.getName() + '.', rs, (RuntimePersistentEntity)embeddedEntity, true, null, null, null);
                } else {
                    String columnName = this.resolveColumnName(identity, prefix, isEmbedded, hasPrefix);
                    id = this.resultReader.readDynamic(rs, columnName, DataType.OBJECT);
                    if (id == null) {
                        return null;
                    }
                }
            }
            if (ArrayUtils.isEmpty((Object[])constructorArguments)) {
                entity = introspection.instantiate();
            } else {
                int len = constructorArguments.length;
                Object[] args = new Object[len];
                for (int i = 0; i < len; ++i) {
                    Object prop = constructorArguments[i];
                    if (prop != null) {
                        Object v;
                        if (prop instanceof Association) {
                            Association constructorAssociation = (Association)prop;
                            boolean isInverse = parent != null && isAssociation && association.getOwner() == constructorAssociation.getAssociatedEntity();
                            kind = constructorAssociation.getKind();
                            if (isInverse && kind.isSingleEnded()) {
                                args[i] = parent;
                                continue;
                            }
                            Object resolvedId = null;
                            if (!constructorAssociation.isForeignKey() && !(constructorAssociation instanceof Embedded)) {
                                String columnName = this.resolveColumnName((RuntimePersistentProperty<R>)prop, prefix, isEmbedded, hasPrefix);
                                resolvedId = this.resultReader.readDynamic(rs, columnName, prop.getDataType());
                            }
                            if (!kind.isSingleEnded()) continue;
                            args[i] = this.readAssociation(parent, hasPrefix ? prefix : "", hasPath ? path : "", rs, constructorAssociation, resolvedId, hasPrefix);
                            continue;
                        }
                        if (resolveId != null && prop.equals(identity)) {
                            v = resolveId;
                        } else {
                            String columnName = this.resolveColumnName((RuntimePersistentProperty<R>)prop, prefix, isEmbedded, hasPrefix);
                            v = this.resultReader.readDynamic(rs, columnName, prop.getDataType());
                            if (v == null) {
                                if (!prop.isOptional() && !nullableEmbedded) {
                                    throw new DataAccessException("Null value read for non-null constructor argument [" + prop.getName() + "] of type: " + persistentEntity.getName());
                                }
                                args[i] = null;
                                continue;
                            }
                        }
                        Class t = prop.getType();
                        args[i] = t.isInstance(v) ? v : this.resultReader.convertRequired(v, t);
                        continue;
                    }
                    throw new DataAccessException("Constructor argument [" + constructorArguments[i].getName() + "] must have an associated getter.");
                }
                if (nullableEmbedded && args.length > 0 && Arrays.stream(args).allMatch(Objects::isNull)) {
                    return null;
                }
                entity = introspection.instantiate(args);
            }
            if (identity != null && id != null && !(idProperty = identity.getProperty()).isReadOnly()) {
                id = this.convertAndSet(entity, identity, idProperty, id, identity.getDataType());
            }
            HashMap<Association, List> toManyJoins = null;
            for (RuntimePersistentProperty rpp : persistentEntity.getPersistentProperties()) {
                DataType dataType;
                Association a;
                Relation.Kind kind2;
                if (rpp.isReadOnly() || rpp.isConstructorArgument() && (!(rpp instanceof Association) || (kind2 = (a = (Association)rpp).getKind()).isSingleEnded())) continue;
                BeanProperty property = rpp.getProperty();
                if (rpp instanceof Association) {
                    Object associated;
                    Association entityAssociation = (Association)rpp;
                    if (!entityAssociation.isForeignKey()) {
                        if (!(entityAssociation instanceof Embedded)) {
                            String columnName = this.resolveColumnName(rpp, prefix, isEmbedded, hasPrefix);
                            Object resolvedId = this.resultReader.readDynamic(rs, columnName, rpp.getDataType());
                            if (resolvedId == null || (associated = this.readAssociation(entity, prefix, hasPath ? path : "", rs, entityAssociation, resolvedId, hasPrefix)) == null) continue;
                            property.set(entity, associated);
                            continue;
                        }
                        Object associated2 = this.readAssociation(entity, prefix, hasPath ? path : "", rs, entityAssociation, null, hasPrefix);
                        if (associated2 == null) continue;
                        property.set(entity, associated2);
                        continue;
                    }
                    boolean hasJoin = this.joinPaths.containsKey((hasPath ? path : "") + entityAssociation.getName());
                    if (!hasJoin) continue;
                    kind = entityAssociation.getKind();
                    if (kind == Relation.Kind.ONE_TO_ONE && entityAssociation.isForeignKey()) {
                        associated = this.readAssociation(entity, prefix, hasPath ? path : "", rs, entityAssociation, null, hasPrefix);
                        if (associated == null) continue;
                        property.set(entity, associated);
                        continue;
                    }
                    if (id == null || kind != Relation.Kind.ONE_TO_MANY && kind != Relation.Kind.MANY_TO_MANY) continue;
                    if (toManyJoins == null) {
                        toManyJoins = new HashMap<Association, List>(3);
                    }
                    toManyJoins.put(entityAssociation, new ArrayList());
                    continue;
                }
                String columnName = this.resolveColumnName(rpp, prefix, isEmbedded, hasPrefix);
                Object v = this.resultReader.readDynamic(rs, columnName, dataType = rpp.getDataType());
                if (v == null) continue;
                this.convertAndSet(entity, rpp, property, v, dataType);
            }
            if (id != null) {
                Object currentId = id;
                if (CollectionUtils.isNotEmpty(toManyJoins)) {
                    while (id.equals(currentId)) {
                        Iterator rpp = toManyJoins.entrySet().iterator();
                        while (rpp.hasNext()) {
                            Map.Entry entry;
                            Object associated = this.readAssociation(entity, hasPrefix ? prefix : "", hasPath ? path : "", rs, (Association)(entry = rpp.next()).getKey(), null, hasPrefix);
                            if (associated == null) continue;
                            ((List)entry.getValue()).add(associated);
                        }
                        String columnName = this.resolveColumnName(identity, prefix, isEmbedded, hasPrefix);
                        currentId = this.nextId(identity, rs, columnName);
                    }
                    if (currentId != null) {
                        this.callNext = false;
                    }
                    toManyJoins.forEach((key, value) -> {
                        RuntimePersistentProperty joinAssociation = (RuntimePersistentProperty)key;
                        BeanProperty property = joinAssociation.getProperty();
                        this.convertAndSet(entity, joinAssociation, property, value, joinAssociation.getDataType());
                    });
                }
            }
            return (R)entity;
        }
        catch (InstantiationException e) {
            throw new DataAccessException("Error instantiating entity [" + persistentEntity.getName() + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    private String resolveColumnName(RuntimePersistentProperty<R> identity, String prefix, boolean isEmbedded, boolean hasPrefix) {
        String persistedName = identity.getPersistedName();
        String columnName = hasPrefix ? (isEmbedded && identity.getAnnotationMetadata().stringValue(MappedProperty.class).isPresent() ? persistedName : prefix + persistedName) : persistedName;
        return columnName;
    }

    Object nextId(@NonNull RuntimePersistentProperty<R> identity, @NonNull RS resultSet, @NonNull String columnName) {
        if (this.hasNext(resultSet)) {
            Object id = this.resultReader.readDynamic(resultSet, columnName, identity.getDataType());
            if (id == null) {
                return null;
            }
            Class isType = identity.getType();
            return isType.isInstance(id) ? id : this.resultReader.convertRequired(id, isType);
        }
        return null;
    }

    private Object convertAndSet(R entity, RuntimePersistentProperty<R> rpp, BeanProperty<R, Object> property, Object v, DataType dataType) {
        Class propertyType = rpp.getType();
        if (v instanceof Array) {
            try {
                v = ((Array)v).getArray();
            }
            catch (SQLException e) {
                throw new DataAccessException("Error getting an array value: " + e.getMessage(), (Throwable)e);
            }
        }
        Object r = propertyType.isInstance(v) ? v : (dataType == DataType.JSON && this.jsonCodec != null ? this.jsonCodec.decode(rpp.getArgument(), v.toString()) : this.resultReader.convertRequired(v, rpp.getArgument()));
        property.set(entity, r);
        return r;
    }

    @Nullable
    private Object readAssociation(Object parent, String prefix, String path, RS resultSet, @NonNull Association association, @Nullable Object resolvedId, boolean hasPrefix) {
        RuntimePersistentEntity associatedEntity = (RuntimePersistentEntity)association.getAssociatedEntity();
        Object associated = null;
        String associationName = association.getName();
        if (association instanceof Embedded) {
            associated = this.readEntity(association.getPersistedName() + "_", path + associationName + '.', resultSet, associatedEntity, true, association, null, null);
        } else {
            String persistedName = association.getPersistedName();
            RuntimePersistentProperty identity = associatedEntity.getIdentity();
            String joinPath = path + associationName;
            if (this.joinPaths.containsKey(joinPath)) {
                JoinPath jp = this.joinPaths.get(joinPath);
                String newPrefix = jp.getAlias().orElse(!hasPrefix ? association.getAliasName() : prefix + association.getAliasName());
                associated = this.readEntity(newPrefix, path + associationName + '.', resultSet, associatedEntity, false, association, parent, resolvedId);
            } else {
                Argument arg;
                BeanIntrospection associatedIntrospection = associatedEntity.getIntrospection();
                Argument[] constructorArgs = associatedIntrospection.getConstructorArguments();
                if (constructorArgs.length == 0) {
                    associated = associatedIntrospection.instantiate();
                    if (identity != null) {
                        String columnToRead = hasPrefix ? prefix + persistedName : persistedName;
                        Object v = this.resultReader.readDynamic(resultSet, columnToRead, identity.getDataType());
                        BeanWrapper.getWrapper((Object)associated).setProperty(identity.getName(), v);
                    }
                } else if (constructorArgs.length == 1 && identity != null && (arg = constructorArgs[0]).getName().equals(identity.getName()) && arg.getType() == identity.getType()) {
                    Object v = this.resultReader.readDynamic(resultSet, hasPrefix ? prefix + persistedName : persistedName, identity.getDataType());
                    associated = associatedIntrospection.instantiate(new Object[]{this.resultReader.convertRequired(v, identity.getType())});
                }
            }
        }
        return associated;
    }
}

