/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.r2dbc.transaction;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.data.connection.reactive.ReactorConnectionOperations;
import io.micronaut.data.r2dbc.connection.DefaultR2dbcReactorConnectionOperations;
import io.micronaut.data.r2dbc.transaction.R2dbcReactorTransactionOperations;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.reactive.ReactiveTransactionOperations;
import io.micronaut.transaction.reactive.ReactiveTransactionStatus;
import io.micronaut.transaction.support.AbstractReactorTransactionOperations;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.IsolationLevel;
import java.time.Duration;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

@EachBean(value=ConnectionFactory.class)
@Internal
final class DefaultR2dbcReactorTransactionOperations
extends AbstractReactorTransactionOperations<Connection>
implements R2dbcReactorTransactionOperations {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultR2dbcReactorTransactionOperations.class);
    private final String dataSourceName;

    DefaultR2dbcReactorTransactionOperations(@Parameter String dataSourceName, @Parameter DefaultR2dbcReactorConnectionOperations connectionOperations) {
        super((ReactorConnectionOperations)connectionOperations);
        this.dataSourceName = dataSourceName;
    }

    protected Publisher<Void> beginTransaction(ConnectionStatus<Connection> connectionStatus, TransactionDefinition definition) {
        Connection connection = (Connection)connectionStatus.getConnection();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Transaction begin for R2DBC connection: {} and configuration {}.", (Object)connection, (Object)this.dataSourceName);
        }
        Flux result = Flux.empty();
        if (definition.getTimeout().isPresent()) {
            Duration timeout = (Duration)definition.getTimeout().get();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting statement timeout ({}) for transaction: {} for dataSource: {}", new Object[]{timeout, definition.getName(), this.dataSourceName});
            }
            result = result.thenMany(connection.setStatementTimeout(timeout));
        }
        if (definition.getIsolationLevel().isPresent()) {
            IsolationLevel isolationLevel = this.getIsolationLevel(definition);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting Isolation Level ({}) for transaction: {} for dataSource: {}", new Object[]{isolationLevel, definition.getName(), this.dataSourceName});
            }
            if (isolationLevel != null) {
                result = result.thenMany(connection.setTransactionIsolationLevel(isolationLevel));
            }
        }
        return result.thenMany(connection.beginTransaction());
    }

    protected Publisher<Void> commitTransaction(ConnectionStatus<Connection> connectionStatus, TransactionDefinition transactionDefinition) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Committing transaction for R2DBC connection: {} and configuration {}.", connectionStatus.getConnection(), (Object)this.dataSourceName);
        }
        return ((Connection)connectionStatus.getConnection()).commitTransaction();
    }

    protected Publisher<Void> rollbackTransaction(ConnectionStatus<Connection> connectionStatus, TransactionDefinition transactionDefinition) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Rolling back transaction for R2DBC connection: {} and configuration {}.", connectionStatus.getConnection(), (Object)this.dataSourceName);
        }
        return ((Connection)connectionStatus.getConnection()).rollbackTransaction();
    }

    private IsolationLevel getIsolationLevel(TransactionDefinition definition) {
        return definition.getIsolationLevel().map(isolation -> switch (isolation) {
            case TransactionDefinition.Isolation.READ_COMMITTED -> IsolationLevel.READ_COMMITTED;
            case TransactionDefinition.Isolation.READ_UNCOMMITTED -> IsolationLevel.READ_UNCOMMITTED;
            case TransactionDefinition.Isolation.REPEATABLE_READ -> IsolationLevel.REPEATABLE_READ;
            case TransactionDefinition.Isolation.SERIALIZABLE -> IsolationLevel.SERIALIZABLE;
            default -> null;
        }).orElse(null);
    }

    @Override
    public <T> Publisher<T> withTransaction(ReactiveTransactionStatus<Connection> status, TransactionDefinition definition, ReactiveTransactionOperations.TransactionalCallback<Connection, T> handler) {
        return this.withTransactionFlux(status, definition, handler);
    }
}

