/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.r2dbc.operations;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.r2dbc.operations.R2dbcSchemaHandler;
import io.micronaut.data.runtime.config.DataSettings;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.Result;
import jakarta.inject.Singleton;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Singleton
@Internal
final class DefaultR2dbcSchemaHandler
implements R2dbcSchemaHandler {
    DefaultR2dbcSchemaHandler() {
    }

    @Override
    public Publisher<Void> createSchema(Connection connection, Dialect dialect, String name) {
        if (dialect == Dialect.ORACLE) {
            return DefaultR2dbcSchemaHandler.executeQuery(connection, "CREATE DATABASE " + name + ";");
        }
        return DefaultR2dbcSchemaHandler.executeQuery(connection, "CREATE SCHEMA " + name + ";");
    }

    @Override
    public Publisher<Void> useSchema(Connection connection, Dialect dialect, String name) {
        return switch (dialect) {
            case Dialect.ORACLE -> DefaultR2dbcSchemaHandler.executeQuery(connection, "ALTER SESSION SET CURRENT_SCHEMA=" + name);
            case Dialect.SQL_SERVER -> DefaultR2dbcSchemaHandler.executeQuery(connection, "USE " + name + ";");
            case Dialect.POSTGRES -> DefaultR2dbcSchemaHandler.executeQuery(connection, "SET SCHEMA '" + name + "';");
            case Dialect.MYSQL -> DefaultR2dbcSchemaHandler.executeQuery(connection, "USE " + name + ";");
            case Dialect.H2 -> DefaultR2dbcSchemaHandler.executeQuery(connection, "SET SCHEMA " + name + ";");
            default -> Mono.error((Throwable)new DataAccessException("Unsupported 'useSchema' for dialect:" + String.valueOf(dialect)));
        };
    }

    private static Publisher<Void> executeQuery(Connection connection, String query) {
        if (DataSettings.QUERY_LOG.isTraceEnabled()) {
            DataSettings.QUERY_LOG.trace("Executing Query: {}", (Object)query);
        }
        return Flux.from((Publisher)connection.createStatement(query).execute()).flatMap(Result::getRowsUpdated).then();
    }
}

