/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.r2dbc.operations;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.exceptions.OptimisticLockException;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.r2dbc.operations.R2dbcExceptionMapper;
import io.r2dbc.spi.R2dbcException;
import jakarta.inject.Singleton;

@Singleton
@Internal
final class OracleR2dbcExceptionMapper
implements R2dbcExceptionMapper {
    private static final int JSON_VIEW_ETAG_NOT_MATCHING_ERROR = 42699;

    OracleR2dbcExceptionMapper() {
    }

    @Override
    public Dialect getDialect() {
        return Dialect.ORACLE;
    }

    @Override
    @Nullable
    public DataAccessException mapR2dbcException(@NonNull R2dbcException r2dbcException) {
        if (r2dbcException.getErrorCode() == 42699) {
            return new OptimisticLockException("ETAG did not match when updating record: " + r2dbcException.getMessage(), (Throwable)r2dbcException);
        }
        return null;
    }
}

