/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.r2dbc.mapper;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.model.DataType;
import io.micronaut.data.r2dbc.mapper.ColumnNameR2dbcResultReader;
import io.micronaut.data.runtime.mapper.AbstractDelegatingResultReader;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.List;
import java.util.Set;

@Internal
public class ColumnNameExistenceAwareR2dbcResultSetReader
extends AbstractDelegatingResultReader<Row, String> {
    private Set<String> knownColumns;

    public ColumnNameExistenceAwareR2dbcResultSetReader() {
        super((ResultReader)new ColumnNameR2dbcResultReader());
    }

    public Object readDynamic(Row row, String index, DataType dataType) {
        if (!this.containsColumnName(row, index)) {
            return null;
        }
        return super.readDynamic((Object)row, (Object)index, dataType);
    }

    private boolean containsColumnName(Row row, String name) {
        if (this.knownColumns == null) {
            RowMetadata metadata = row.getMetadata();
            List columnMetadatas = metadata.getColumnMetadatas();
            this.knownColumns = CollectionUtils.newHashSet((int)columnMetadatas.size());
            for (ColumnMetadata columnMetadata : columnMetadatas) {
                this.knownColumns.add(columnMetadata.getName().toLowerCase());
            }
        }
        return this.knownColumns.contains(name.toLowerCase());
    }
}

