/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.r2dbc.connection;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.data.connection.async.AsyncUsingReactiveConnectionOperations;
import io.micronaut.data.connection.reactive.ReactorConnectionOperations;
import io.micronaut.data.connection.sync.SynchronousConnectionOperationsFromReactiveConnectionOperations;
import io.r2dbc.spi.ConnectionFactory;
import jakarta.inject.Named;
import java.util.concurrent.ExecutorService;

@Factory
final class R2dbcConnectionManagerFactory {
    R2dbcConnectionManagerFactory() {
    }

    @EachBean(value=ConnectionFactory.class)
    <T> SynchronousConnectionOperationsFromReactiveConnectionOperations<T> buildSynchronousTransactionManager(@Parameter ReactorConnectionOperations<T> reactorConnectionOperations, @Named(value="io") ExecutorService executorService) {
        return new SynchronousConnectionOperationsFromReactiveConnectionOperations(reactorConnectionOperations, executorService);
    }

    @EachBean(value=ConnectionFactory.class)
    <T> AsyncUsingReactiveConnectionOperations<T> buildAsyncTransactionOperations(@Parameter ReactorConnectionOperations<T> reactorConnectionOperations) {
        return new AsyncUsingReactiveConnectionOperations(reactorConnectionOperations);
    }
}

