/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.r2dbc.mapper;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.r2dbc.mapper.R2dbcTuple;
import io.micronaut.data.runtime.mapper.sql.SqlTypeMapper;
import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import jakarta.persistence.Tuple;
import java.util.HashMap;
import java.util.List;

@Internal
public final class RowTupleMapper
implements SqlTypeMapper<Row, Tuple> {
    private final ConversionService conversionService;

    public RowTupleMapper(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public boolean hasNext(Row resultSet) {
        return false;
    }

    public Tuple map(Row rs, Class<Tuple> type) throws DataAccessException {
        RowMetadata metaData = rs.getMetadata();
        List columnMetadatas = metaData.getColumnMetadatas();
        Object[] values = new Object[columnMetadatas.size()];
        HashMap aliasToPosition = CollectionUtils.newHashMap((int)values.length);
        int i = 0;
        for (ColumnMetadata columnMetadata : columnMetadatas) {
            values[i] = rs.get(i);
            String alias = columnMetadata.getName();
            aliasToPosition.put(alias, i);
            ++i;
        }
        return new R2dbcTuple(this.conversionService, values, aliasToPosition);
    }

    public Object read(Row object, String name) {
        throw new UnsupportedOperationException();
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }
}

