/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.r2dbc.config;

import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.Named;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.r2dbc.operations.R2dbcOperations;
import io.micronaut.data.runtime.config.SchemaGenerate;
import io.r2dbc.spi.ConnectionFactory;
import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.List;

@EachProperty(value="r2dbc.datasources", primary="default")
public class DataR2dbcConfiguration
implements Named {
    private SchemaGenerate schemaGenerate = SchemaGenerate.NONE;
    private boolean batchGenerate = false;
    private Dialect dialect = Dialect.ANSI;
    private List<String> packages = new ArrayList<String>(3);
    private final String name;
    private final ConnectionFactory connectionFactory;
    private final Provider<R2dbcOperations> r2dbcOperations;
    @Nullable
    private String schemaGenerateName;
    @Nullable
    private List<String> schemaGenerateNames;

    public DataR2dbcConfiguration(@Parameter String name, @Parameter ConnectionFactory connectionFactory, @Parameter Provider<R2dbcOperations> r2dbcOperations) {
        this.name = name;
        this.connectionFactory = connectionFactory;
        this.r2dbcOperations = r2dbcOperations;
    }

    public R2dbcOperations getR2dbcOperations() {
        return (R2dbcOperations)this.r2dbcOperations.get();
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public SchemaGenerate getSchemaGenerate() {
        return this.schemaGenerate;
    }

    public void setSchemaGenerate(SchemaGenerate schemaGenerate) {
        if (schemaGenerate != null) {
            this.schemaGenerate = schemaGenerate;
        }
    }

    public boolean isBatchGenerate() {
        return this.batchGenerate;
    }

    public void setBatchGenerate(boolean batchGenerate) {
        this.batchGenerate = batchGenerate;
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public void setPackages(List<String> packages) {
        if (packages != null) {
            this.packages = packages;
        }
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getSchemaGenerateName() {
        return this.schemaGenerateName;
    }

    public void setSchemaGenerateName(@Nullable String schemaGenerateName) {
        this.schemaGenerateName = schemaGenerateName;
    }

    @Nullable
    public List<String> getSchemaGenerateNames() {
        return this.schemaGenerateNames;
    }

    public void setSchemaGenerateNames(@Nullable List<String> schemaGenerateNames) {
        this.schemaGenerateNames = schemaGenerateNames;
    }
}

