/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders.spec;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.Delete;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractSpecificationMethodMatcher;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.TypedElement;

@Internal
public class DeleteAllSpecificationMethodMatcher
extends AbstractSpecificationMethodMatcher {
    public DeleteAllSpecificationMethodMatcher() {
        super("delete", "remove", "erase", "eliminate");
    }

    @Override
    protected boolean matches(MethodMatchContext matchContext) {
        return matchContext.getMethodElement().hasStereotype(Delete.class) || super.matches(matchContext);
    }

    @Override
    protected MethodMatcher.MethodMatch doMatch(MethodMatchContext matchContext) {
        if (TypeUtils.isValidBatchUpdateReturnType(matchContext.getMethodElement()) && this.isDeleteSpecification(matchContext)) {
            FindersUtils.InterceptorMatch e = FindersUtils.pickDeleteAllSpecInterceptor(matchContext, matchContext.getReturnType());
            return mc -> new MethodMatchInfo(DataMethod.OperationType.DELETE, (TypedElement)e.returnType(), e.interceptor());
        }
        return null;
    }
}

