/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.data.intercept.CountInterceptor;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.DeleteAllInterceptor;
import io.micronaut.data.intercept.DeleteAllReturningInterceptor;
import io.micronaut.data.intercept.DeleteOneInterceptor;
import io.micronaut.data.intercept.DeleteReturningManyInterceptor;
import io.micronaut.data.intercept.DeleteReturningOneInterceptor;
import io.micronaut.data.intercept.ExistsByInterceptor;
import io.micronaut.data.intercept.FindAllInterceptor;
import io.micronaut.data.intercept.FindByIdInterceptor;
import io.micronaut.data.intercept.FindCursoredPageInterceptor;
import io.micronaut.data.intercept.FindOneInterceptor;
import io.micronaut.data.intercept.FindOptionalInterceptor;
import io.micronaut.data.intercept.FindPageInterceptor;
import io.micronaut.data.intercept.FindSliceInterceptor;
import io.micronaut.data.intercept.FindStreamInterceptor;
import io.micronaut.data.intercept.InsertReturningManyInterceptor;
import io.micronaut.data.intercept.InsertReturningOneInterceptor;
import io.micronaut.data.intercept.ProcedureReturningManyInterceptor;
import io.micronaut.data.intercept.ProcedureReturningOneInterceptor;
import io.micronaut.data.intercept.SaveAllInterceptor;
import io.micronaut.data.intercept.SaveEntityInterceptor;
import io.micronaut.data.intercept.SaveOneInterceptor;
import io.micronaut.data.intercept.UpdateAllEntitiesInterceptor;
import io.micronaut.data.intercept.UpdateEntityInterceptor;
import io.micronaut.data.intercept.UpdateInterceptor;
import io.micronaut.data.intercept.UpdateReturningManyInterceptor;
import io.micronaut.data.intercept.UpdateReturningOneInterceptor;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.intercept.async.CountAsyncInterceptor;
import io.micronaut.data.intercept.async.DeleteAllAsyncInterceptor;
import io.micronaut.data.intercept.async.DeleteOneAsyncInterceptor;
import io.micronaut.data.intercept.async.ExistsByAsyncInterceptor;
import io.micronaut.data.intercept.async.FindAllAsyncInterceptor;
import io.micronaut.data.intercept.async.FindByIdAsyncInterceptor;
import io.micronaut.data.intercept.async.FindCursoredAsyncPageInterceptor;
import io.micronaut.data.intercept.async.FindOneAsyncInterceptor;
import io.micronaut.data.intercept.async.FindPageAsyncInterceptor;
import io.micronaut.data.intercept.async.FindSliceAsyncInterceptor;
import io.micronaut.data.intercept.async.ProcedureReturningManyAsyncInterceptor;
import io.micronaut.data.intercept.async.ProcedureReturningOneAsyncInterceptor;
import io.micronaut.data.intercept.async.SaveAllAsyncInterceptor;
import io.micronaut.data.intercept.async.SaveEntityAsyncInterceptor;
import io.micronaut.data.intercept.async.SaveOneAsyncInterceptor;
import io.micronaut.data.intercept.async.UpdateAllEntriesAsyncInterceptor;
import io.micronaut.data.intercept.async.UpdateAsyncInterceptor;
import io.micronaut.data.intercept.async.UpdateEntityAsyncInterceptor;
import io.micronaut.data.intercept.reactive.CountReactiveInterceptor;
import io.micronaut.data.intercept.reactive.DeleteAllReactiveInterceptor;
import io.micronaut.data.intercept.reactive.DeleteOneReactiveInterceptor;
import io.micronaut.data.intercept.reactive.ExistsByReactiveInterceptor;
import io.micronaut.data.intercept.reactive.FindAllReactiveInterceptor;
import io.micronaut.data.intercept.reactive.FindByIdReactiveInterceptor;
import io.micronaut.data.intercept.reactive.FindCursoredReactivePageInterceptor;
import io.micronaut.data.intercept.reactive.FindOneReactiveInterceptor;
import io.micronaut.data.intercept.reactive.FindPageReactiveInterceptor;
import io.micronaut.data.intercept.reactive.FindSliceReactiveInterceptor;
import io.micronaut.data.intercept.reactive.ProcedureReactiveInterceptor;
import io.micronaut.data.intercept.reactive.SaveAllReactiveInterceptor;
import io.micronaut.data.intercept.reactive.SaveEntityReactiveInterceptor;
import io.micronaut.data.intercept.reactive.SaveOneReactiveInterceptor;
import io.micronaut.data.intercept.reactive.UpdateAllEntitiesReactiveInterceptor;
import io.micronaut.data.intercept.reactive.UpdateEntityReactiveInterceptor;
import io.micronaut.data.intercept.reactive.UpdateReactiveInterceptor;
import io.micronaut.data.model.Slice;
import io.micronaut.data.processor.visitors.FindInterceptorDef;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;

@Internal
public interface FindersUtils {
    public static List<FindInterceptorDef> getDefaultInterceptors(VisitorContext visitorContext) {
        return List.of(new FindInterceptorDef((ClassElement)visitorContext.getClassElement(Stream.class).orElseThrow(), (ClassElement)visitorContext.getClassElement(FindStreamInterceptor.class).orElseThrow()), new FindInterceptorDef((ClassElement)visitorContext.getClassElement(Optional.class).orElseThrow(), (ClassElement)visitorContext.getClassElement(FindOptionalInterceptor.class).orElseThrow()));
    }

    public static InterceptorMatch resolveInterceptorTypeByOperationType(boolean hasEntityParameter, boolean hasMultipleEntityParameter, DataMethod.OperationType operationType, MethodMatchContext matchContext) {
        ClassElement returnType = matchContext.getMethodElement().getGenericReturnType();
        return switch (operationType) {
            default -> throw new MatchException(null, null);
            case DataMethod.OperationType.DELETE -> {
                if (hasEntityParameter) {
                    yield FindersUtils.pickDeleteInterceptor(matchContext, returnType);
                }
                yield FindersUtils.pickDeleteAllInterceptor(matchContext, returnType);
            }
            case DataMethod.OperationType.DELETE_RETURNING -> {
                boolean returnsEntity = TypeUtils.doesMethodProducesAnEntityIterableOfAnEntity(matchContext.getMethodElement());
                InterceptorMatch updateEntry = hasEntityParameter && returnsEntity ? FindersUtils.pickDeleteInterceptor(matchContext, returnType) : (hasMultipleEntityParameter && returnsEntity ? FindersUtils.pickDeleteAllReturningInterceptor(matchContext, returnType) : FindersUtils.pickDeleteReturningInterceptor(matchContext, returnType));
                if (FindersUtils.isContainer(updateEntry.returnType, Iterable.class)) {
                    yield FindersUtils.typeAndInterceptorEntry((ClassElement)updateEntry.returnType.getFirstTypeArgument().orElseThrow(IllegalStateException::new), updateEntry.interceptor);
                }
                yield updateEntry;
            }
            case DataMethod.OperationType.UPDATE -> {
                InterceptorMatch updateEntry = hasMultipleEntityParameter ? FindersUtils.pickUpdateAllEntitiesInterceptor(matchContext, returnType) : (hasEntityParameter ? FindersUtils.pickUpdateEntityInterceptor(matchContext, returnType) : FindersUtils.pickUpdateInterceptor(matchContext, returnType));
                if (FindersUtils.isContainer(updateEntry.returnType, Iterable.class)) {
                    yield FindersUtils.typeAndInterceptorEntry((ClassElement)updateEntry.returnType.getFirstTypeArgument().orElseThrow(IllegalStateException::new), updateEntry.interceptor);
                }
                yield updateEntry;
            }
            case DataMethod.OperationType.UPDATE_RETURNING -> {
                boolean returnsEntity = TypeUtils.doesMethodProducesAnEntityIterableOfAnEntity(matchContext.getMethodElement());
                InterceptorMatch updateEntry = hasMultipleEntityParameter && returnsEntity ? FindersUtils.pickUpdateAllEntitiesInterceptor(matchContext, returnType) : (hasEntityParameter && returnsEntity ? FindersUtils.pickUpdateEntityInterceptor(matchContext, returnType) : FindersUtils.pickUpdateReturningInterceptor(matchContext, returnType));
                if (FindersUtils.isContainer(updateEntry.returnType, Iterable.class)) {
                    yield FindersUtils.typeAndInterceptorEntry((ClassElement)updateEntry.returnType.getFirstTypeArgument().orElseThrow(IllegalStateException::new), updateEntry.interceptor);
                }
                yield updateEntry;
            }
            case DataMethod.OperationType.INSERT -> {
                InterceptorMatch saveEntry = hasEntityParameter ? FindersUtils.pickSaveEntityInterceptor(matchContext, returnType) : (hasMultipleEntityParameter ? FindersUtils.pickSaveAllEntitiesInterceptor(matchContext, returnType) : FindersUtils.pickSaveOneInterceptor(matchContext, returnType));
                if (FindersUtils.isContainer(saveEntry.returnType, Iterable.class)) {
                    yield FindersUtils.typeAndInterceptorEntry((ClassElement)saveEntry.returnType.getFirstTypeArgument().orElseThrow(IllegalStateException::new), saveEntry.interceptor);
                }
                yield saveEntry;
            }
            case DataMethod.OperationType.INSERT_RETURNING -> {
                boolean returnsEntity = TypeUtils.doesMethodProducesAnEntityIterableOfAnEntity(matchContext.getMethodElement());
                InterceptorMatch saveEntry = hasEntityParameter && returnsEntity ? FindersUtils.pickSaveEntityInterceptor(matchContext, returnType) : (hasMultipleEntityParameter && returnsEntity ? FindersUtils.pickSaveAllEntitiesInterceptor(matchContext, returnType) : FindersUtils.pickInsertReturningInterceptor(matchContext, returnType));
                if (FindersUtils.isContainer(saveEntry.returnType, Iterable.class)) {
                    yield FindersUtils.typeAndInterceptorEntry((ClassElement)saveEntry.returnType.getFirstTypeArgument().orElseThrow(IllegalStateException::new), saveEntry.interceptor);
                }
                yield saveEntry;
            }
            case DataMethod.OperationType.QUERY, DataMethod.OperationType.COUNT, DataMethod.OperationType.EXISTS -> FindersUtils.resolveFindInterceptor(matchContext, returnType);
        };
    }

    private static InterceptorMatch pickUpdateReturningInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isContainer(returnType, Iterable.class)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getFirstTypeArgument().orElse(returnType), UpdateReturningManyInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getType(), UpdateReturningOneInterceptor.class);
    }

    private static InterceptorMatch pickDeleteReturningInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isContainer(returnType, Iterable.class)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getFirstTypeArgument().orElse(returnType), DeleteReturningManyInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getType(), DeleteReturningOneInterceptor.class);
    }

    private static InterceptorMatch pickInsertReturningInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isContainer(returnType, Iterable.class)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getFirstTypeArgument().orElse(returnType), InsertReturningManyInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getType(), InsertReturningOneInterceptor.class);
    }

    public static InterceptorMatch pickSaveOneInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), SaveOneAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getFirstTypeArgument().orElse(null), SaveOneReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getType(), SaveOneInterceptor.class);
    }

    public static InterceptorMatch pickUpdateAllEntitiesInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), UpdateAllEntriesAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getFirstTypeArgument().orElse(null), UpdateAllEntitiesReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getType(), UpdateAllEntitiesInterceptor.class);
    }

    public static InterceptorMatch pickProcedureInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            ClassElement asyncType = FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType);
            if (FindersUtils.isContainer(asyncType, Iterable.class)) {
                return FindersUtils.typeAndInterceptorEntry(matchContext, asyncType.getFirstTypeArgument().orElse(asyncType), ProcedureReturningManyAsyncInterceptor.class);
            }
            return FindersUtils.typeAndInterceptorEntry(matchContext, asyncType, ProcedureReturningOneAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getFirstTypeArgument().orElse(null), ProcedureReactiveInterceptor.class);
        }
        if (FindersUtils.isContainer(returnType, Iterable.class)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getFirstTypeArgument().orElse(returnType), ProcedureReturningManyInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getType(), ProcedureReturningOneInterceptor.class);
    }

    public static InterceptorMatch pickDeleteInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), DeleteOneAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getFirstTypeArgument().orElse(FindersUtils.voidType(matchContext)), DeleteOneReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getType(), DeleteOneInterceptor.class);
    }

    public static InterceptorMatch pickDeleteAllInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), DeleteAllAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getFirstTypeArgument().orElse(FindersUtils.voidType(matchContext)), DeleteAllReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getType(), DeleteAllInterceptor.class);
    }

    private static ClassElement voidType(MethodMatchContext matchContext) {
        return (ClassElement)matchContext.getVisitorContext().getClassElement(Void.class).get();
    }

    public static InterceptorMatch pickDeleteAllReturningInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getType(), DeleteAllReturningInterceptor.class);
    }

    public static InterceptorMatch pickSaveEntityInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), SaveEntityAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getReactiveTypeOrVoid(matchContext, returnType), SaveEntityReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getType(), SaveEntityInterceptor.class);
    }

    private static ClassElement getReactiveTypeOrVoid(MethodMatchContext matchContext, ClassElement returnType) {
        return returnType.getFirstTypeArgument().orElse(FindersUtils.voidType(matchContext));
    }

    public static InterceptorMatch pickSaveAllEntitiesInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), SaveAllAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getFirstTypeArgument().orElse(null), SaveAllReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getType(), SaveAllInterceptor.class);
    }

    public static InterceptorMatch pickUpdateInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), UpdateAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getFirstTypeArgument().orElse(null), UpdateReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getType(), UpdateInterceptor.class);
    }

    public static InterceptorMatch pickUpdateEntityInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), UpdateEntityAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getFirstTypeArgument().orElse(null), UpdateEntityReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getType(), UpdateEntityInterceptor.class);
    }

    public static InterceptorMatch resolveFindInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        InterceptorMatch entry = FindersUtils.isFutureType(matchContext.getMethodElement(), returnType) ? FindersUtils.resolveAsyncFindInterceptor(matchContext, FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType)) : (FindersUtils.isReactiveType(returnType) ? FindersUtils.resolveReactiveFindInterceptor(matchContext, FindersUtils.getFirstTypeArgumentOrFail(matchContext, returnType), FindersUtils.isReactiveSingleResult(returnType)) : FindersUtils.resolveSyncFindInterceptor(matchContext, returnType));
        return entry;
    }

    private static InterceptorMatch resolveSyncFindInterceptor(@NonNull MethodMatchContext matchContext, @NonNull ClassElement returnType) {
        FindInterceptorDef findInterceptorDef = matchContext.getFindInterceptors().get(returnType);
        if (findInterceptorDef != null) {
            if (findInterceptorDef.isContainer() && FindersUtils.isContainer(returnType, findInterceptorDef.returnType())) {
                return new InterceptorMatch(FindersUtils.getFirstTypeArgumentOrFail(matchContext, returnType), findInterceptorDef.interceptor());
            }
            return new InterceptorMatch(findInterceptorDef.returnType(), findInterceptorDef.interceptor(), false);
        }
        if (FindersUtils.isCursoredPage(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getFirstTypeArgumentOrFail(matchContext, returnType), FindCursoredPageInterceptor.class);
        }
        if (FindersUtils.isPage(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getFirstTypeArgumentOrFail(matchContext, returnType), FindPageInterceptor.class);
        }
        if (FindersUtils.isSlice(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getFirstTypeArgumentOrFail(matchContext, returnType), FindSliceInterceptor.class);
        }
        if (FindersUtils.isContainer(returnType, Iterable.class)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getFirstTypeArgumentOrFail(matchContext, returnType), FindAllInterceptor.class);
        }
        if (returnType.isArray()) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.fromArray(), FindAllInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(matchContext, returnType, FindOneInterceptor.class);
    }

    private static ClassElement getFirstTypeArgumentOrFail(MethodMatchContext matchContext, ClassElement returnType) {
        return FindersUtils.getFirstTypeArgumentOrFail(matchContext.getMethodElement(), returnType);
    }

    private static ClassElement getFirstTypeArgumentOrFail(MethodElement methodElement, ClassElement returnType) {
        return (ClassElement)returnType.getFirstTypeArgument().orElseThrow(FindersUtils.failOnMissingGeneric(methodElement, returnType));
    }

    private static InterceptorMatch resolveReactiveFindInterceptor(@NonNull MethodMatchContext matchContext, @NonNull ClassElement returnType, boolean singleResult) {
        if (FindersUtils.isCursoredPage(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getFirstTypeArgumentOrFail(matchContext, returnType), FindCursoredReactivePageInterceptor.class);
        }
        if (FindersUtils.isPage(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getFirstTypeArgumentOrFail(matchContext, returnType), FindPageReactiveInterceptor.class);
        }
        if (FindersUtils.isSlice(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getFirstTypeArgumentOrFail(matchContext, returnType), FindSliceReactiveInterceptor.class);
        }
        if (singleResult) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, returnType, FindOneReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(matchContext, returnType, FindAllReactiveInterceptor.class);
    }

    private static InterceptorMatch resolveAsyncFindInterceptor(@NonNull MethodMatchContext matchContext, @NonNull ClassElement asyncType) {
        if (FindersUtils.isCursoredPage(matchContext, asyncType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getFirstTypeArgumentOrFail(matchContext, asyncType), FindCursoredAsyncPageInterceptor.class);
        }
        if (FindersUtils.isPage(matchContext, asyncType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getFirstTypeArgumentOrFail(matchContext, asyncType), FindPageAsyncInterceptor.class);
        }
        if (FindersUtils.isSlice(matchContext, asyncType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getFirstTypeArgumentOrFail(matchContext, asyncType), FindSliceAsyncInterceptor.class);
        }
        if (FindersUtils.isContainer(asyncType, Iterable.class)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getFirstTypeArgumentOrFail(matchContext, asyncType), FindAllAsyncInterceptor.class);
        }
        if (FindersUtils.isContainer(asyncType, Optional.class)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getFirstTypeArgumentOrFail(matchContext, asyncType), FindOneAsyncInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(matchContext, asyncType, FindOneAsyncInterceptor.class);
    }

    public static InterceptorMatch pickCountInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), CountAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getFirstTypeArgument().orElse(null), CountReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getType(), CountInterceptor.class);
    }

    public static InterceptorMatch pickExistsInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), ExistsByAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getFirstTypeArgument().orElse(null), ExistsByReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getType(), ExistsByInterceptor.class);
    }

    public static InterceptorMatch pickFindByIdInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), FindByIdAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getFirstTypeArgument().orElse(null), FindByIdReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getType(), FindByIdInterceptor.class);
    }

    public static InterceptorMatch pickFindOneInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), FindOneAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getFirstTypeArgument().orElse(null), FindOneReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(matchContext, returnType.getType(), FindOneInterceptor.class);
    }

    public static InterceptorMatch pickCountSpecInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.async.CountAsyncSpecificationInterceptor"));
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry(returnType.getFirstTypeArgument().orElse(null), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.reactive.CountReactiveSpecificationInterceptor"));
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.CountSpecificationInterceptor"));
    }

    public static InterceptorMatch pickDeleteAllSpecInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.async.DeleteAllAsyncSpecificationInterceptor"));
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry(returnType.getFirstTypeArgument().orElse(null), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.reactive.DeleteAllReactiveSpecificationInterceptor"));
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.DeleteAllSpecificationInterceptor"));
    }

    public static InterceptorMatch pickSpecInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.pickFindAsyncSpecInterceptor(matchContext, FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType));
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.pickFindReactiveSpecInterceptor(matchContext, returnType.getFirstTypeArgument().orElse(returnType), FindersUtils.isReactiveSingleResult(returnType));
        }
        return FindersUtils.pickFindSyncSpecInterceptor(matchContext, returnType);
    }

    private static InterceptorMatch pickFindSyncSpecInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isCursoredPage(matchContext, returnType) || FindersUtils.isPage(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getFirstTypeArgumentOrFail(matchContext, returnType), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.FindPageSpecificationInterceptor"));
        }
        if (FindersUtils.isContainer(returnType, Iterable.class) || FindersUtils.isContainer(returnType, Stream.class)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getFirstTypeArgumentOrFail(matchContext, returnType), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.FindAllSpecificationInterceptor"));
        }
        if (FindersUtils.isContainer(returnType, Optional.class)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getFirstTypeArgumentOrFail(matchContext, returnType), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.FindOneSpecificationInterceptor"));
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.FindOneSpecificationInterceptor"));
    }

    private static InterceptorMatch pickFindAsyncSpecInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isCursoredPage(matchContext, returnType) || FindersUtils.isPage(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getFirstTypeArgumentOrFail(matchContext, returnType), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.async.FindPageAsyncSpecificationInterceptor"));
        }
        if (FindersUtils.isContainer(returnType, Iterable.class)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getFirstTypeArgumentOrFail(matchContext, returnType), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.async.FindAllAsyncSpecificationInterceptor"));
        }
        if (FindersUtils.isContainer(returnType, Optional.class)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getFirstTypeArgumentOrFail(matchContext, returnType), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.async.FindOneAsyncSpecificationInterceptor"));
        }
        return FindersUtils.typeAndInterceptorEntry(returnType, FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.async.FindOneAsyncSpecificationInterceptor"));
    }

    private static InterceptorMatch pickFindReactiveSpecInterceptor(MethodMatchContext matchContext, ClassElement returnType, boolean singleResult) {
        if (FindersUtils.isCursoredPage(matchContext, returnType) || FindersUtils.isPage(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getFirstTypeArgumentOrFail(matchContext, returnType), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.reactive.FindPageReactiveSpecificationInterceptor"));
        }
        if (FindersUtils.isContainer(returnType, Iterable.class)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getFirstTypeArgumentOrFail(matchContext, returnType), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.reactive.FindAllReactiveSpecificationInterceptor"));
        }
        if (FindersUtils.isContainer(returnType, Optional.class)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getFirstTypeArgumentOrFail(matchContext, returnType), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.reactive.FindOneReactiveSpecificationInterceptor"));
        }
        if (singleResult) {
            return FindersUtils.typeAndInterceptorEntry(returnType, FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.reactive.FindOneReactiveSpecificationInterceptor"));
        }
        return FindersUtils.typeAndInterceptorEntry(returnType, FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.reactive.FindAllReactiveSpecificationInterceptor"));
    }

    private static Supplier<ProcessingException> failOnMissingGeneric(MethodElement methodElement, ClassElement returnType) {
        return () -> new ProcessingException((Element)methodElement, "Expected a type " + returnType.getName() + " to have a generic value, got: " + String.valueOf(returnType));
    }

    public static InterceptorMatch pickUpdateAllSpecInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.async.UpdateAllAsyncSpecificationInterceptor"));
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry(returnType.getFirstTypeArgument().orElse(null), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.reactive.UpdateAllReactiveSpecificationInterceptor"));
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.UpdateAllSpecificationInterceptor"));
    }

    public static InterceptorMatch pickExistsSpecInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        if (FindersUtils.isFutureType(matchContext.getMethodElement(), returnType)) {
            return FindersUtils.typeAndInterceptorEntry(FindersUtils.getAsyncType(matchContext.getMethodElement(), returnType), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.async.ExistsAsyncSpecificationInterceptor"));
        }
        if (FindersUtils.isReactiveType(returnType)) {
            return FindersUtils.typeAndInterceptorEntry(returnType.getFirstTypeArgument().orElse(null), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.reactive.ExistsReactiveSpecificationInterceptor"));
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), FindersUtils.getInterceptorElement(matchContext, "io.micronaut.data.runtime.intercept.criteria.ExistsSpecificationInterceptor"));
    }

    public static ClassElement getAsyncType(@NonNull MethodElement methodElement, @NonNull ClassElement returnType) {
        if (methodElement.isSuspend()) {
            return TypeUtils.getKotlinCoroutineProducedType(methodElement);
        }
        return FindersUtils.getFirstTypeArgumentOrFail(methodElement, returnType);
    }

    public static InterceptorMatch typeAndInterceptorEntry(MethodMatchContext matchContext, ClassElement type, Class<? extends DataInterceptor> interceptor) {
        return new InterceptorMatch(type, FindersUtils.getInterceptorElement(matchContext, interceptor));
    }

    public static InterceptorMatch typeAndInterceptorEntry(ClassElement type, ClassElement interceptor) {
        return new InterceptorMatch(type, interceptor);
    }

    public static boolean isFutureType(MethodElement methodElement, @Nullable ClassElement type) {
        return methodElement.isSuspend() || FindersUtils.isOneOfContainers(type, CompletionStage.class, Future.class);
    }

    public static boolean isReactiveType(@Nullable ClassElement type) {
        return FindersUtils.isContainer(type, Publisher.class) || TypeUtils.isReactiveType(type) && (type.getTypeArguments().isEmpty() || FindersUtils.isContainer(type, type.getName()));
    }

    public static boolean isCursoredPage(MethodMatchContext methodMatchContext, ClassElement typeArgument) {
        boolean matches = methodMatchContext.isTypeInRole(typeArgument, "cursoredPage");
        if (matches && !methodMatchContext.hasParameterInRole("pageable")) {
            methodMatchContext.fail("Method must accept an argument that is a Pageable");
        }
        return matches;
    }

    public static boolean isPage(MethodMatchContext methodMatchContext, ClassElement typeArgument) {
        boolean matches = methodMatchContext.isTypeInRole(typeArgument, "page");
        if (matches && !methodMatchContext.hasParameterInRole("pageable")) {
            methodMatchContext.fail("Method must accept an argument that is a Pageable");
        }
        return matches;
    }

    public static boolean isSlice(MethodMatchContext methodMatchContext, ClassElement typeArgument) {
        boolean matches = methodMatchContext.isTypeInRole(typeArgument, "slice");
        if (matches && !methodMatchContext.hasParameterInRole("pageable")) {
            methodMatchContext.fail("Method must accept an argument that is a Pageable");
        }
        return FindersUtils.isContainer(typeArgument, Slice.class);
    }

    public static boolean isContainer(ClassElement typeArgument, Class<?> containerType) {
        if (typeArgument == null) {
            return false;
        }
        if (typeArgument.isAssignable(containerType)) {
            ClassElement type = typeArgument.getFirstTypeArgument().orElse(null);
            if (type == null) {
                throw new MatchFailedException("'" + String.valueOf(containerType) + "' return type missing type argument");
            }
            return true;
        }
        return false;
    }

    public static boolean isContainer(ClassElement typeArgument, ClassElement containerType) {
        if (typeArgument == null) {
            return false;
        }
        if (typeArgument.equals((Object)containerType)) {
            ClassElement type = typeArgument.getFirstTypeArgument().orElse(null);
            if (type == null) {
                throw new MatchFailedException("'" + String.valueOf(containerType) + "' return type missing type argument");
            }
            return true;
        }
        return false;
    }

    public static boolean isOneOfContainers(ClassElement typeArgument, Class<?> ... containers) {
        if (typeArgument == null) {
            return false;
        }
        for (Class<?> containerType : containers) {
            if (!FindersUtils.isContainer(typeArgument, containerType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainer(ClassElement typeArgument, String containerType) {
        if (typeArgument.isAssignable(containerType)) {
            ClassElement type = typeArgument.getFirstTypeArgument().orElse(null);
            if (type == null) {
                throw new MatchFailedException("'" + containerType + "' return type missing type argument");
            }
            return true;
        }
        return false;
    }

    public static boolean isValidResultType(ClassElement returnType) {
        return returnType.hasStereotype(Introspected.class) || ClassUtils.isJavaBasicType((String)returnType.getName()) || returnType.isPrimitive();
    }

    public static boolean isReactiveSingleResult(ClassElement returnType) {
        return returnType.hasStereotype(SingleResult.class) || FindersUtils.isContainer(returnType, "io.reactivex.Single") || FindersUtils.isContainer(returnType, "reactor.core.publisher.Mono");
    }

    public static ClassElement getInterceptorElement(@NonNull MethodMatchContext matchContext, Class<? extends DataInterceptor> type) {
        return matchContext.getVisitorContext().getClassElement(type).orElseGet(() -> new DynamicClassElement(type));
    }

    public static ClassElement getInterceptorElement(@NonNull MethodMatchContext matchContext, String type) {
        return (ClassElement)matchContext.getVisitorContext().getClassElement(type).orElseThrow(() -> new IllegalStateException("Unable to apply interceptor of type: " + type + ". The interceptor was not found on the classpath. Check your annotation processor configuration and try again."));
    }

    public record InterceptorMatch(ClassElement returnType, ClassElement interceptor, boolean validateReturnType) {
        public InterceptorMatch(ClassElement returnType, ClassElement interceptor) {
            this(returnType, interceptor, true);
        }
    }

    public static class DynamicClassElement
    implements ClassElement {
        private final Class<? extends DataInterceptor> type;

        DynamicClassElement(Class<? extends DataInterceptor> type) {
            this.type = type;
        }

        public boolean isAssignable(String type) {
            return false;
        }

        public ClassElement toArray() {
            return new DynamicClassElement(Array.newInstance(this.type, 0).getClass());
        }

        public ClassElement fromArray() {
            return new DynamicClassElement(this.type.getComponentType());
        }

        public @NonNull String getName() {
            return this.type.getName();
        }

        public boolean isProtected() {
            return Modifier.isProtected(this.type.getModifiers());
        }

        public boolean isPublic() {
            return Modifier.isPublic(this.type.getModifiers());
        }

        public @NonNull Object getNativeType() {
            return this.type;
        }
    }
}

